---
UID: NF:gpedit.ImportRSoPData
title: ImportRSoPData function (gpedit.h)
description: The ImportRSoPData function imports a data file containing RSoP data to a WMI namespace. The file must be one generated by a call to the ExportRSoPData function.
old-location: policy\importrsopdata.htm
tech.root: Policy
ms.assetid: d3b4ef2e-a828-445a-83de-d5c9e4a4d98b
ms.date: 12/05/2018
ms.keywords: ImportRSoPData, ImportRSoPData function [Group Policy], _win32_importrsopdata, gpedit/ImportRSoPData, policy.importrsopdata
f1_keywords:
- gpedit/ImportRSoPData
dev_langs:
- c++
req.header: gpedit.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista
req.target-min-winversvr: Windows Server 2008
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Gpedit.lib
req.dll: Gpedit.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- DllExport
api_location:
- Gpedit.dll
api_name:
- ImportRSoPData
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# ImportRSoPData function


## -description


The
    <b>ImportRSoPData</b> function imports a data file containing RSoP data to a WMI namespace. The file must be one generated by a call to the 
<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/gpedit/nf-gpedit-exportrsopdata">ExportRSoPData</a> function.


## -parameters




### -param lpNameSpace [in]

Pointer to a string specifying the namespace to contain the RSoP data. The namespace must exist prior to calling 
<b>ImportRSoPData</b>.


### -param lpFileName [in]

Pointer to a string specifying the name of the file that contains the RSoP data.


## -returns



If the function succeeds, the return value is <b>S_OK</b>. Otherwise, the function returns one of the COM error codes defined in the Platform SDK header file WinError.h.




## -see-also




<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/gpedit/nf-gpedit-exportrsopdata">ExportRSoPData</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/Policy/group-policy-functions">Group Policy
    Functions</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/Policy/about-group-policy">Group Policy
    Overview</a>
 

 

