---
UID: NE:highlevelmonitorconfigurationapi._MC_COLOR_TEMPERATURE
title: MC_COLOR_TEMPERATURE (highlevelmonitorconfigurationapi.h)
description: Describes a monitor's color temperature.
old-location: monitor\mc_color_temperature.htm
tech.root: Monitor
ms.assetid: 890d1d84-6a7d-457b-8136-230be4c79e78
ms.date: 12/05/2018
ms.keywords: '*LPMC_COLOR_TEMPERATURE, LPMC_COLOR_TEMPERATURE, LPMC_COLOR_TEMPERATURE enumeration pointer [Monitor Configuration], MC_COLOR_TEMPERATURE, MC_COLOR_TEMPERATURE , MC_COLOR_TEMPERATURE enumeration [Monitor Configuration], MC_COLOR_TEMPERATURE_10000K, MC_COLOR_TEMPERATURE_11500K, MC_COLOR_TEMPERATURE_4000K, MC_COLOR_TEMPERATURE_5000K, MC_COLOR_TEMPERATURE_6500K, MC_COLOR_TEMPERATURE_7500K, MC_COLOR_TEMPERATURE_8200K, MC_COLOR_TEMPERATURE_9300K, MC_COLOR_TEMPERATURE_UNKNOWN, highlevelmonitorconfigurationapi/LPMC_COLOR_TEMPERATURE, highlevelmonitorconfigurationapi/MC_COLOR_TEMPERATURE, highlevelmonitorconfigurationapi/MC_COLOR_TEMPERATURE_10000K, highlevelmonitorconfigurationapi/MC_COLOR_TEMPERATURE_11500K, highlevelmonitorconfigurationapi/MC_COLOR_TEMPERATURE_4000K, highlevelmonitorconfigurationapi/MC_COLOR_TEMPERATURE_5000K, highlevelmonitorconfigurationapi/MC_COLOR_TEMPERATURE_6500K, highlevelmonitorconfigurationapi/MC_COLOR_TEMPERATURE_7500K, highlevelmonitorconfigurationapi/MC_COLOR_TEMPERATURE_8200K, highlevelmonitorconfigurationapi/MC_COLOR_TEMPERATURE_9300K, highlevelmonitorconfigurationapi/MC_COLOR_TEMPERATURE_UNKNOWN, monitor.mc_color_temperature'
f1_keywords:
- highlevelmonitorconfigurationapi/MC_COLOR_TEMPERATURE
dev_langs:
- c++
req.header: highlevelmonitorconfigurationapi.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- HighLevelMonitorConfigurationAPI.h
api_name:
- MC_COLOR_TEMPERATURE
targetos: Windows
req.typenames: MC_COLOR_TEMPERATURE, *LPMC_COLOR_TEMPERATURE
req.redist: 
ms.custom: 19H1
---

# MC_COLOR_TEMPERATURE enumeration


## -description


Describes a monitor's color temperature.
      


## -enum-fields




### -field MC_COLOR_TEMPERATURE_UNKNOWN

Unknown temperature.
          


### -field MC_COLOR_TEMPERATURE_4000K

4,000 kelvins (K).
          


### -field MC_COLOR_TEMPERATURE_5000K

5,000 K.
          


### -field MC_COLOR_TEMPERATURE_6500K

6,500 K.
          


### -field MC_COLOR_TEMPERATURE_7500K

7,500 K.
          


### -field MC_COLOR_TEMPERATURE_8200K

8,200 K.
          


### -field MC_COLOR_TEMPERATURE_9300K

9,300 K
          


### -field MC_COLOR_TEMPERATURE_10000K

10,000 K.
          


### -field MC_COLOR_TEMPERATURE_11500K

11,500 K.
          


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/highlevelmonitorconfigurationapi/nf-highlevelmonitorconfigurationapi-getmonitorcolortemperature">GetMonitorColorTemperature</a>



<a href="https://docs.microsoft.com/windows/desktop/Monitor/monitor-configuration-enumeration-types">Monitor Configuration Enumeration Types</a>



<a href="https://docs.microsoft.com/windows/desktop/api/highlevelmonitorconfigurationapi/nf-highlevelmonitorconfigurationapi-setmonitorcolortemperature">SetMonitorColorTemperature</a>
 

 

