---
UID: NE:highlevelmonitorconfigurationapi._MC_DISPLAY_TECHNOLOGY_TYPE
title: MC_DISPLAY_TECHNOLOGY_TYPE (highlevelmonitorconfigurationapi.h)
description: Identifies monitor display technologies.
old-location: monitor\mc_display_technology_type.htm
tech.root: Monitor
ms.assetid: 22cb7b73-931c-4cab-a359-f957ec457148
ms.date: 12/05/2018
ms.keywords: '*LPMC_DISPLAY_TECHNOLOGY_TYPE, LPMC_DISPLAY_TECHNOLOGY_TYPE, LPMC_DISPLAY_TECHNOLOGY_TYPE enumeration pointer [Monitor Configuration], MC_APERTURE_GRILL_CATHODE_RAY_TUBE, MC_DISPLAY_TECHNOLOGY_TYPE, MC_DISPLAY_TECHNOLOGY_TYPE , MC_DISPLAY_TECHNOLOGY_TYPE enumeration [Monitor Configuration], MC_ELECTROLUMINESCENT, MC_FIELD_EMISSION_DEVICE, MC_LIQUID_CRYSTAL_ON_SILICON, MC_MICROELECTROMECHANICAL, MC_ORGANIC_LIGHT_EMITTING_DIODE, MC_PLASMA, MC_SHADOW_MASK_CATHODE_RAY_TUBE, MC_THIN_FILM_TRANSISTOR, highlevelmonitorconfigurationapi/LPMC_DISPLAY_TECHNOLOGY_TYPE, highlevelmonitorconfigurationapi/MC_APERTURE_GRILL_CATHODE_RAY_TUBE, highlevelmonitorconfigurationapi/MC_DISPLAY_TECHNOLOGY_TYPE, highlevelmonitorconfigurationapi/MC_ELECTROLUMINESCENT, highlevelmonitorconfigurationapi/MC_FIELD_EMISSION_DEVICE, highlevelmonitorconfigurationapi/MC_LIQUID_CRYSTAL_ON_SILICON, highlevelmonitorconfigurationapi/MC_MICROELECTROMECHANICAL, highlevelmonitorconfigurationapi/MC_ORGANIC_LIGHT_EMITTING_DIODE, highlevelmonitorconfigurationapi/MC_PLASMA, highlevelmonitorconfigurationapi/MC_SHADOW_MASK_CATHODE_RAY_TUBE, highlevelmonitorconfigurationapi/MC_THIN_FILM_TRANSISTOR, monitor.mc_display_technology_type'
f1_keywords:
- highlevelmonitorconfigurationapi/MC_DISPLAY_TECHNOLOGY_TYPE
dev_langs:
- c++
req.header: highlevelmonitorconfigurationapi.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- HighLevelMonitorConfigurationAPI.h
api_name:
- MC_DISPLAY_TECHNOLOGY_TYPE
targetos: Windows
req.typenames: MC_DISPLAY_TECHNOLOGY_TYPE, *LPMC_DISPLAY_TECHNOLOGY_TYPE
req.redist: 
ms.custom: 19H1
---

# MC_DISPLAY_TECHNOLOGY_TYPE enumeration


## -description


Identifies monitor display technologies.
      


## -enum-fields




### -field MC_SHADOW_MASK_CATHODE_RAY_TUBE

Shadow-mask cathode ray tube (CRT).
          


### -field MC_APERTURE_GRILL_CATHODE_RAY_TUBE

Aperture-grill CRT.
          


### -field MC_THIN_FILM_TRANSISTOR

Thin-film transistor (TFT) display.
          


### -field MC_LIQUID_CRYSTAL_ON_SILICON

Liquid crystal on silicon (LCOS) display.
          


### -field MC_PLASMA

Plasma display.
          


### -field MC_ORGANIC_LIGHT_EMITTING_DIODE

Organic light emitting diode (LED) display.
          


### -field MC_ELECTROLUMINESCENT

Electroluminescent display.
          


### -field MC_MICROELECTROMECHANICAL

Microelectromechanical display.
          


### -field MC_FIELD_EMISSION_DEVICE

Field emission device (FED) display.
          


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/highlevelmonitorconfigurationapi/nf-highlevelmonitorconfigurationapi-getmonitortechnologytype">GetMonitorTechnologyType</a>



<a href="https://docs.microsoft.com/windows/desktop/Monitor/monitor-configuration-enumeration-types">Monitor Configuration Enumeration Types</a>
 

 

