---
UID: NN:holographicspaceinterop.IHolographicSpaceInterop
title: IHolographicSpaceInterop (holographicspaceinterop.h)
description: Enables interoperability with a Universal Windows Platform (UWP) HolographicSpace object and provides access to HolographicSpace members for representing a holographic scene.
old-location: mixedreality\iholographicspaceinterop.htm
tech.root: MixedReality
ms.assetid: 119299C1-ECD9-46BA-B499-66890225E4E0
ms.date: 01/25/2019
ms.keywords: IHolographicSpaceInterop, IHolographicSpaceInterop interface, IHolographicSpaceInterop interface,described, MixedReality.iholographicspaceinterop, holographicspaceinterop/IHolographicSpaceInterop
f1_keywords:
- holographicspaceinterop/IHolographicSpaceInterop
dev_langs:
- c++
req.header: holographicspaceinterop.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 10, version 1703 [desktop apps only]
req.target-min-winversvr: None supported
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: HolographicSpaceInterop.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- HolographicSpaceInterop.h
api_name:
- IHolographicSpaceInterop
targetos: Windows
req.typenames: 
req.redist: 
---

# IHolographicSpaceInterop interface

## -description

Enables interoperability with a Univeral Windows Platform (UWP) [HolographicSpace](/uwp/api/windows.graphics.holographic.holographicspace) object, and provides access to **HolographicSpace** members for representing a holographic scene.

## -members

The **ISpatialInteractionManagerInterop** interface has these methods.

|Method|Description|
|-|-|
|[CreateForWindow](nf-holographicspaceinterop-iholographicspaceinterop-createforwindow.md)|Instantiates a [HolographicSpace](/uwp/api/windows.graphics.holographic.holographicspace) object, and binds it to the current application.|

## -see-also

* [HolographicSpace](/uwp/api/windows.graphics.holographic.holographicspace)
* [Mixed Reality Dev Center](/windows/mixed-reality)
* [Windows.Graphics.Holographic](/uwp/api/windows.graphics.holographic)
