---
UID: NE:http._HTTP_HEADER_ID
title: HTTP_HEADER_ID (http.h)
description: The HTTP_HEADER_ID enumeration type lists known headers for HTTP requests and responses, and associates an array index with each such header.
old-location: http\http_header_id.htm
tech.root: http
ms.assetid: 6c4ccaf0-2a9f-43fe-9f35-cda1dd1fbbdc
ms.date: 12/05/2018
ms.keywords: '*PHTTP_HEADER_ID, HTTP_HEADER_ID, HTTP_HEADER_ID enumeration [HTTP], HttpHeaderAccept, HttpHeaderAcceptCharset, HttpHeaderAcceptEncoding, HttpHeaderAcceptLanguage, HttpHeaderAcceptRanges, HttpHeaderAge, HttpHeaderAllow, HttpHeaderAuthorization, HttpHeaderCacheControl, HttpHeaderConnection, HttpHeaderContentEncoding, HttpHeaderContentLanguage, HttpHeaderContentLength, HttpHeaderContentLocation, HttpHeaderContentMd5, HttpHeaderContentRange, HttpHeaderContentType, HttpHeaderCookie, HttpHeaderDate, HttpHeaderEtag, HttpHeaderExpect, HttpHeaderExpires, HttpHeaderFrom, HttpHeaderHost, HttpHeaderIfMatch, HttpHeaderIfModifiedSince, HttpHeaderIfNoneMatch, HttpHeaderIfRange, HttpHeaderIfUnmodifiedSince, HttpHeaderKeepAlive, HttpHeaderLastModified, HttpHeaderLocation, HttpHeaderMaxForwards, HttpHeaderMaximum, HttpHeaderPragma, HttpHeaderProxyAuthenticate, HttpHeaderProxyAuthorization, HttpHeaderRange, HttpHeaderReferer, HttpHeaderRequestMaximum, HttpHeaderResponseMaximum, HttpHeaderRetryAfter, HttpHeaderServer, HttpHeaderSetCookie, HttpHeaderTe, HttpHeaderTrailer, HttpHeaderTransferEncoding, HttpHeaderTranslate, HttpHeaderUpgrade, HttpHeaderUserAgent, HttpHeaderVary, HttpHeaderVia, HttpHeaderWarning, HttpHeaderWwwAuthenticate, PHTTP_HEADER_ID, PHTTP_HEADER_ID enumeration pointer [HTTP], _http_http_header_id, http.http_header_id, http/HTTP_HEADER_ID, http/HttpHeaderAccept, http/HttpHeaderAcceptCharset, http/HttpHeaderAcceptEncoding, http/HttpHeaderAcceptLanguage, http/HttpHeaderAcceptRanges, http/HttpHeaderAge, http/HttpHeaderAllow, http/HttpHeaderAuthorization, http/HttpHeaderCacheControl, http/HttpHeaderConnection, http/HttpHeaderContentEncoding, http/HttpHeaderContentLanguage, http/HttpHeaderContentLength, http/HttpHeaderContentLocation, http/HttpHeaderContentMd5, http/HttpHeaderContentRange, http/HttpHeaderContentType, http/HttpHeaderCookie, http/HttpHeaderDate, http/HttpHeaderEtag, http/HttpHeaderExpect, http/HttpHeaderExpires, http/HttpHeaderFrom, http/HttpHeaderHost, http/HttpHeaderIfMatch, http/HttpHeaderIfModifiedSince, http/HttpHeaderIfNoneMatch, http/HttpHeaderIfRange, http/HttpHeaderIfUnmodifiedSince, http/HttpHeaderKeepAlive, http/HttpHeaderLastModified, http/HttpHeaderLocation, http/HttpHeaderMaxForwards, http/HttpHeaderMaximum, http/HttpHeaderPragma, http/HttpHeaderProxyAuthenticate, http/HttpHeaderProxyAuthorization, http/HttpHeaderRange, http/HttpHeaderReferer, http/HttpHeaderRequestMaximum, http/HttpHeaderResponseMaximum, http/HttpHeaderRetryAfter, http/HttpHeaderServer, http/HttpHeaderSetCookie, http/HttpHeaderTe, http/HttpHeaderTrailer, http/HttpHeaderTransferEncoding, http/HttpHeaderTranslate, http/HttpHeaderUpgrade, http/HttpHeaderUserAgent, http/HttpHeaderVary, http/HttpHeaderVia, http/HttpHeaderWarning, http/HttpHeaderWwwAuthenticate, http/PHTTP_HEADER_ID'
f1_keywords:
- http/HTTP_HEADER_ID
dev_langs:
- c++
req.header: http.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista, Windows XP with SP2 [desktop apps only]
req.target-min-winversvr: Windows Server 2003 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Http.h
api_name:
- HTTP_HEADER_ID
targetos: Windows
req.typenames: HTTP_HEADER_ID, *PHTTP_HEADER_ID
req.redist: 
ms.custom: 19H1
---

# HTTP_HEADER_ID enumeration


## -description


The 
<b>HTTP_HEADER_ID</b> enumeration type lists <i>known headers</i> for HTTP requests and responses, and associates an array index with each such header. It is used to size and access the <b>KnownHeaders</b> array members of the 
<a href="https://docs.microsoft.com/windows/desktop/api/http/ns-http-http_request_headers">HTTP_REQUEST_HEADERS</a> and 
<a href="https://docs.microsoft.com/windows/desktop/api/http/ns-http-http_response_headers">HTTP_RESPONSE_HEADERS</a> structures.


## -enum-fields




### -field HttpHeaderCacheControl

Used to specify caching behavior along the request or response chain, overriding the default caching algorithm.


### -field HttpHeaderConnection

Allows the sender to specify options that are desired for that particular connection. These are used for a single connection only and must not be communicated by proxies over further connections.


### -field HttpHeaderDate

The Date is a general header field that indicates the time that the request or response was sent.


### -field HttpHeaderKeepAlive

Based on the keepalive XML element (see <a href="Http://go.microsoft.com/fwlink/p/?linkid=84046">RFC 2518</a>, section 12.12.1, page 66); a list of URIs included in the KeepAlive
   header must be "live" after they are copied
   (moved) to the destination.


### -field HttpHeaderPragma

Used to include optional, implementation-specific directives that might apply to any recipient along the request/response chain.


### -field HttpHeaderTrailer

Indicates that specified header fields are present in the trailer of a message encoded with chunked transfer-coding.


### -field HttpHeaderTransferEncoding

Indicates what, if any, transformations have been applied to the message body in transit.


### -field HttpHeaderUpgrade

Allows the client to specify one or more other communication protocols it would prefer to use if the server can comply.


### -field HttpHeaderVia

The Via header field indicates the path taken by the request.


### -field HttpHeaderWarning

This is a response header that contains the 3-digit warn code along with the reason phrase.


### -field HttpHeaderAllow

Lists the set of methods supported by the resource identified by the Request-URI.


### -field HttpHeaderContentLength

The size of the message body in decimal bytes.


### -field HttpHeaderContentType

The media type of the message body.


### -field HttpHeaderContentEncoding

The encoding scheme for the message body.


### -field HttpHeaderContentLanguage

Provides the natural language of the intended audience.


### -field HttpHeaderContentLocation

Location of the resource for the entity enclosed in the message when that entity is accessible from a location separate from the requested resource's URI.


### -field HttpHeaderContentMd5

An MD5 digest of the entity-body used to provide end-to-end message integrity check (MIC) of the entity-body.


### -field HttpHeaderContentRange

The content range header is sent with a partial entity body to specify where in the full entity body the partial body should be applied.


### -field HttpHeaderExpires

The date and time after which the message content expires.


### -field HttpHeaderLastModified

Indicates the date and time at which the origin server believes the variant was last modified.


### -field HttpHeaderAccept

Used with the INVITE, OPTIONS, and REGISTER methods to indicate what media types are acceptable in the response.


### -field HttpHeaderAcceptCharset

Indicates the character sets that are acceptable for the response.


### -field HttpHeaderAcceptEncoding

The content encodings that are acceptable in the response.


### -field HttpHeaderAcceptLanguage

Used by the client to indicate to the server which language it would prefer to receive reason phrases, session descriptions, or status responses.


### -field HttpHeaderAuthorization

The user-agent can authenticate itself with a server by sending the Authorization request header field with the request. The field contains the credentials for the domain that the user is requesting.


### -field HttpHeaderCookie

The cookie request header contains data used to maintain client state with the server. Cookie data is obtained from a response sent with <b>HttpHeaderSetCookie</b>.


### -field HttpHeaderExpect

Indicates the specific server behaviors that are required by the client.


### -field HttpHeaderFrom

The From header field specifies the initiator of the SIP request or response message.


### -field HttpHeaderHost

Specifies the Internet host and port number of the requested resource. This is obtained from the original URI given by the user or referring resource.


### -field HttpHeaderIfMatch

The If-Match request header field is used with a method to make it conditional. A client that has one or more entities previously obtained from the resource can verify that one of those entities is current by including a list of their associated entity tags in the If-Match header field.


### -field HttpHeaderIfModifiedSince

The If-Modified-Since request header field is used with a method to make it conditional. If the requested variant has not been modified since the time specified in this field, an entity is  not  returned from the server; instead, a 304 (not modified) response is returned without any message-body.


### -field HttpHeaderIfNoneMatch

The If-None-Match request-header field is used with a method to make
   it conditional. When a client has obtained one or more entities from a resource, it can verify that none of those entities is
   current by including a list of their associated entity tags in the
   If-None-Match header field. The purpose of this feature is to allow
   efficient updates of cached information with a minimum amount of
   transaction overhead, and to prevent a method such as PUT
   from inadvertently modifying an existing resource when the client
   believes that the resource does not exist.


### -field HttpHeaderIfRange

If a client has a partial copy of an entity in its cache, and wishes
   to obtain an up-to-date copy of the entire entity, it
   can use the If-Range header. Informally, its meaning is, "if the entity is unchanged, send
   me the part(s) I am missing; otherwise, send me the entire new
   entity."


### -field HttpHeaderIfUnmodifiedSince

The If-Unmodified-Since request-header field is used with a method to
   make it conditional. If the requested resource has not been modified
   since the time specified in this field, the server performs the
   requested operation as if the If-Unmodified-Since header were not
   present, but

   if the requested resource has been modified,
   the server returns
   a 412 error (Precondition Failed).


### -field HttpHeaderMaxForwards

The maximum number of proxies or gateways that can forward the request.


### -field HttpHeaderProxyAuthorization

This header field is used by the client to identify itself with a proxy.


### -field HttpHeaderReferer

Allows the client to specify, for the server's benefit, the address (URI) of the resource from which the Request-URI was obtained.


### -field HttpHeaderRange

Allows a client to request a part of an entity instead of the whole.


### -field HttpHeaderTe

This header field contains the recipient of the SIP request or response message.


### -field HttpHeaderTranslate

Allows the client to specify whether it wants the source representation or programmatic interpretation of the requested content.


### -field HttpHeaderUserAgent

Indicates what extension transfer-codings the client accepts in the response and whether or not the client  accepts trailer fields in a chunked transfer-coding.


### -field HttpHeaderRequestMaximum

Not a value that actually designates a header; instead, it is used to count the enumerated Request headers.


### -field HttpHeaderAcceptRanges

Allows the server to indicate its acceptance of range requests for a resource.


### -field HttpHeaderAge

Conveys the sender's estimate of the amount of time since the response (or its revalidation) was generated at the origin server.


### -field HttpHeaderEtag

Provides the current value of the entity tag for the requested variant.


### -field HttpHeaderLocation

Used to redirect the recipient to a location other than the Request-URI for completion of the request or identification of a new resource.


### -field HttpHeaderProxyAuthenticate

The response field that must be included as a part of the 407 response. The field includes the authentication scheme and parameters that apply to the proxy for this Request-URI.


### -field HttpHeaderRetryAfter

The length of time that the service is expected to be unavailable to the requesting client.


### -field HttpHeaderServer

This is a response header field that contains information about the server that is handling the request.


### -field HttpHeaderSetCookie

The <b>set-cookie</b> response header contains data used to maintain client state in future requests sent with <b>HttpHeaderCookie</b>.


### -field HttpHeaderVary

Indicates the set of request header fields that fully determines, while the response is fresh, whether a cache is permitted to use the response to reply to a subsequent request without revalidation.


### -field HttpHeaderWwwAuthenticate

The WWW_Authenticate header field contains the authentication schemes and parameters applicable to the Request-URI.


### -field HttpHeaderResponseMaximum

Not a value that actually designates a header; instead, it is used to count the enumerated Response headers.


### -field HttpHeaderMaximum

Not a value that actually designates a header; instead, it is used to count all the enumerated headers.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/http/ns-http-http_request_headers">HTTP_REQUEST_HEADERS</a>



<a href="https://docs.microsoft.com/windows/desktop/api/http/ns-http-http_response_headers">HTTP_RESPONSE_HEADERS</a>
 

 

