---
UID: NF:http.HTTP_SET_NULL_ID
title: HTTP_SET_NULL_ID macro (http.h)
description: The HTTP_SET_NULL_ID macro sets the HTTP_OPAQUE_ID to NULL.
old-location: http\http_set_null_id.htm
tech.root: http
ms.assetid: d4a15361-3346-4c05-a3df-4503da183549
ms.date: 12/05/2018
ms.keywords: HTTP_SET_NULL_ID, HTTP_SET_NULL_ID macro [HTTP], http.http_set_null_id, http/HTTP_SET_NULL_ID
f1_keywords:
- http/HTTP_SET_NULL_ID
dev_langs:
- c++
req.header: http.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- http.h
api_name:
- HTTP_SET_NULL_ID
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# HTTP_SET_NULL_ID macro


## -description


The <b>HTTP_SET_NULL_ID</b> macro sets the <a href="https://docs.microsoft.com/windows/desktop/Http/http-server-api-version-2-0-data-types">HTTP_OPAQUE_ID</a> to <b>NULL</b>.


## -parameters




### -param pid

The identifier that is set to <b>NULL</b>.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/Http/http-server-api-version-2-0-macros">HTTP Server API Version 2.0 Macros</a>



<a href="https://docs.microsoft.com/windows/desktop/api/http/nf-http-http_is_null_id">HTTP_IS_NULL_ID</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/legacy/aa364541(v=vs.85)">HTTP_NULL_ID</a>
 

 

