---
UID: NE:iads.__MIDL___MIDL_itf_ads_0000_0000_0001
title: ADSTYPEENUM (iads.h)
description: Used to identify the data type of an ADSI property value.
old-location: adsi\adstypeenum.htm
tech.root: adsi
ms.assetid: e601bae5-80bf-43f5-846f-11327889419a
ms.date: 12/05/2018
ms.keywords: ADSTYPE, ADSTYPE enumeration [ADSI], ADSTYPEENUM, ADSTYPEENUM enumeration [ADSI], ADSTYPE_BACKLINK, ADSTYPE_BOOLEAN, ADSTYPE_CASEIGNORE_LIST, ADSTYPE_CASE_EXACT_STRING, ADSTYPE_CASE_IGNORE_STRING, ADSTYPE_DN_STRING, ADSTYPE_DN_WITH_BINARY, ADSTYPE_DN_WITH_STRING, ADSTYPE_EMAIL, ADSTYPE_FAXNUMBER, ADSTYPE_HOLD, ADSTYPE_INTEGER, ADSTYPE_INVALID, ADSTYPE_LARGE_INTEGER, ADSTYPE_NETADDRESS, ADSTYPE_NT_SECURITY_DESCRIPTOR, ADSTYPE_NUMERIC_STRING, ADSTYPE_OBJECT_CLASS, ADSTYPE_OCTET_LIST, ADSTYPE_OCTET_STRING, ADSTYPE_PATH, ADSTYPE_POSTALADDRESS, ADSTYPE_PRINTABLE_STRING, ADSTYPE_PROV_SPECIFIC, ADSTYPE_REPLICAPOINTER, ADSTYPE_TIMESTAMP, ADSTYPE_TYPEDNAME, ADSTYPE_UNKNOWN, ADSTYPE_UTC_TIME, _ds_adstypeenum, adsi.adstypeenum, iads/ADSTYPE, iads/ADSTYPEENUM, iads/ADSTYPE_BACKLINK, iads/ADSTYPE_BOOLEAN, iads/ADSTYPE_CASEIGNORE_LIST, iads/ADSTYPE_CASE_EXACT_STRING, iads/ADSTYPE_CASE_IGNORE_STRING, iads/ADSTYPE_DN_STRING, iads/ADSTYPE_DN_WITH_BINARY, iads/ADSTYPE_DN_WITH_STRING, iads/ADSTYPE_EMAIL, iads/ADSTYPE_FAXNUMBER, iads/ADSTYPE_HOLD, iads/ADSTYPE_INTEGER, iads/ADSTYPE_INVALID, iads/ADSTYPE_LARGE_INTEGER, iads/ADSTYPE_NETADDRESS, iads/ADSTYPE_NT_SECURITY_DESCRIPTOR, iads/ADSTYPE_NUMERIC_STRING, iads/ADSTYPE_OBJECT_CLASS, iads/ADSTYPE_OCTET_LIST, iads/ADSTYPE_OCTET_STRING, iads/ADSTYPE_PATH, iads/ADSTYPE_POSTALADDRESS, iads/ADSTYPE_PRINTABLE_STRING, iads/ADSTYPE_PROV_SPECIFIC, iads/ADSTYPE_REPLICAPOINTER, iads/ADSTYPE_TIMESTAMP, iads/ADSTYPE_TYPEDNAME, iads/ADSTYPE_UNKNOWN, iads/ADSTYPE_UTC_TIME
f1_keywords:
- iads/ADSTYPEENUM
dev_langs:
- c++
req.header: iads.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista
req.target-min-winversvr: Windows Server 2008
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Iads.h
api_name:
- ADSTYPEENUM
targetos: Windows
req.typenames: ADSTYPEENUM
req.redist: 
ms.custom: 19H1
---

# ADSTYPEENUM enumeration


## -description


The <b>ADSTYPEENUM</b> enumeration is used to identify the data type of an ADSI property value.


## -enum-fields




### -field ADSTYPE_INVALID

The data type is not valid


### -field ADSTYPE_DN_STRING

The string is of Distinguished Name (path) of a directory service object.


### -field ADSTYPE_CASE_EXACT_STRING

The string is of the case-sensitive type.


### -field ADSTYPE_CASE_IGNORE_STRING

The string is of the case-insensitive type.


### -field ADSTYPE_PRINTABLE_STRING

The string is displayable on screen or in print.


### -field ADSTYPE_NUMERIC_STRING

The string is of a numeral to be interpreted as text.


### -field ADSTYPE_BOOLEAN

The data is of a Boolean value.


### -field ADSTYPE_INTEGER

The data is of an integer value.


### -field ADSTYPE_OCTET_STRING

The string is of a byte array.


### -field ADSTYPE_UTC_TIME

The data is of the universal time as expressed in Universal Time Coordinate (UTC).


### -field ADSTYPE_LARGE_INTEGER

The data is of a long integer value.


### -field ADSTYPE_PROV_SPECIFIC

The string is of a provider-specific string.


### -field ADSTYPE_OBJECT_CLASS

Not used.


### -field ADSTYPE_CASEIGNORE_LIST

The data is of a list of case insensitive strings.


### -field ADSTYPE_OCTET_LIST

The data is of a list of octet strings.


### -field ADSTYPE_PATH

The string is of a directory path.


### -field ADSTYPE_POSTALADDRESS

The string is of the postal address type.


### -field ADSTYPE_TIMESTAMP

The data is of a time stamp in seconds.


### -field ADSTYPE_BACKLINK

The string is of a back link.


### -field ADSTYPE_TYPEDNAME

The string is of a typed name.


### -field ADSTYPE_HOLD

The data is of the Hold data structure.


### -field ADSTYPE_NETADDRESS

The string is of a net address.


### -field ADSTYPE_REPLICAPOINTER

The data is of a replica pointer.


### -field ADSTYPE_FAXNUMBER

The string is of a fax number.


### -field ADSTYPE_EMAIL

The data is of an email message.


### -field ADSTYPE_NT_SECURITY_DESCRIPTOR

The data is a Windows security descriptor as represented by a byte array.


### -field ADSTYPE_UNKNOWN

The data is of an undefined type.


### -field ADSTYPE_DN_WITH_BINARY

The data is of <a href="https://docs.microsoft.com/windows/win32/api/iads/ns-iads-ads_dn_with_binary">ADS_DN_WITH_BINARY</a> used for mapping a distinguished name to a nonvarying GUID. For more information, see Remarks.


### -field ADSTYPE_DN_WITH_STRING

The data is of <a href="https://docs.microsoft.com/windows/win32/api/iads/ns-iads-ads_dn_with_string">ADS_DN_WITH_STRING</a> used for mapping a distinguished name to a nonvarying string value. For more information, see Remarks.


## -remarks



When extending the active directory schema to add <a href="https://docs.microsoft.com/windows/win32/api/iads/ns-iads-ads_dn_with_binary">ADS_DN_WITH_BINARY</a>, you must also specify the "otherWellKnownGuid" attribute definition. Add the following to the ldf file attribute definition: "omObjectClass:: KoZIhvcUAQEBCw=="

When extending the active directory schema to add <a href="https://docs.microsoft.com/windows/win32/api/iads/ns-iads-ads_dn_with_string">ADS_DN_WITH_STRING</a>, you must also specify the "otherWellKnownGuid" attribute definition. Add the following to the ldf file attribute definition: "omObjectClass:: KoZIhvcUAQEBDA=="

Because VBScript cannot read data from a type library, VBScript applications do not recognize symbolic constants, as defined above. Use the numerical constants instead to set the appropriate flags in your VBScript application. To use the symbolic constants as a good programming practice, write explicit declarations of such constants, as done here, in your VBScript application.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/ADSI/adsi-enumerations">ADSI Enumerations</a>
 

 

