---
UID: NE:icftypes.NET_FW_IP_PROTOCOL_
title: NET_FW_IP_PROTOCOL (icftypes.h)
description: Specifies the Internet protocol.
old-location: ics\net_fw_ip_protocol.htm
tech.root: ics
ms.assetid: 867a038c-ae8e-4da8-a3e9-3ca7cb6ba518
ms.date: 12/05/2018
ms.keywords: NET_FW_IP_PROTOCOL, NET_FW_IP_PROTOCOL enumeration [ICS/ICF], NET_FW_IP_PROTOCOL_TCP, NET_FW_IP_PROTOCOL_UDP, icftypes/NET_FW_IP_PROTOCOL, icftypes/NET_FW_IP_PROTOCOL_TCP, icftypes/NET_FW_IP_PROTOCOL_UDP, ics.net_fw_ip_protocol
f1_keywords:
- icftypes/NET_FW_IP_PROTOCOL
dev_langs:
- c++
req.header: icftypes.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows XP with SP2 [desktop apps only]
req.target-min-winversvr: None supported
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Icftypes.h
api_name:
- NET_FW_IP_PROTOCOL
targetos: Windows
req.typenames: NET_FW_IP_PROTOCOL
req.redist: 
ms.custom: 19H1
---

# NET_FW_IP_PROTOCOL enumeration


## -description


<p class="CCE_Message">[The Windows Firewall API is available for use in the operating systems specified in the Requirements section. It may be altered or unavailable in subsequent versions. For Windows Vista and later, use of the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/ics/windows-firewall-advanced-security-start-page">Windows Firewall with Advanced Security</a> API is recommended.]
<p class="CCE_Message">[The Windows Firewall API is available for use in the operating systems specified in the Requirements section. It may be altered or unavailable in subsequent versions. For Windows Vista and later, use of the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/ics/windows-firewall-advanced-security-start-page">Windows Firewall with Advanced Security</a> API is recommended.]

The 
<b>NET_FW_IP_PROTOCOL</b> enumeration type specifies the Internet protocol.


## -enum-fields




### -field NET_FW_IP_PROTOCOL_TCP

Transmission Control Protocol.


### -field NET_FW_IP_PROTOCOL_UDP

User Datagram Protocol.


### -field NET_FW_IP_PROTOCOL_ANY




## -see-also




<a href="https://docs.microsoft.com/previous-versions/windows/desktop/ics/windows-firewall-enumerated-types">Windows Firewall Enumeration Types</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/ics/windows-firewall-reference">Windows Firewall Reference</a>
 

 

