---
UID: NE:icftypes.NET_FW_POLICY_TYPE_
title: NET_FW_POLICY_TYPE (icftypes.h)
description: The NET_FW_POLICY_TYPE enumerated type specifies the type of policy.
old-location: ics\net_fw_policy_type.htm
tech.root: ics
ms.assetid: 10b052d6-55d1-4583-9fd4-ebb02548d1db
ms.date: 12/05/2018
ms.keywords: NET_FW_POLICY_EFFECTIVE, NET_FW_POLICY_GROUP, NET_FW_POLICY_LOCAL, NET_FW_POLICY_TYPE, NET_FW_POLICY_TYPE enumeration [ICS/ICF], NET_FW_POLICY_TYPE_MAX, icftypes/NET_FW_POLICY_EFFECTIVE, icftypes/NET_FW_POLICY_GROUP, icftypes/NET_FW_POLICY_LOCAL, icftypes/NET_FW_POLICY_TYPE, icftypes/NET_FW_POLICY_TYPE_MAX, ics.net_fw_policy_type
f1_keywords:
- icftypes/NET_FW_POLICY_TYPE
dev_langs:
- c++
req.header: icftypes.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows XP with SP2 [desktop apps only]
req.target-min-winversvr: None supported
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Icftypes.h
api_name:
- NET_FW_POLICY_TYPE
targetos: Windows
req.typenames: NET_FW_POLICY_TYPE
req.redist: 
ms.custom: 19H1
---

# NET_FW_POLICY_TYPE enumeration


## -description


<p class="CCE_Message">[The Windows Firewall API is available for use in the operating systems specified in the Requirements section. It may be altered or unavailable in subsequent versions. For Windows Vista and later, use of the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/ics/windows-firewall-advanced-security-start-page">Windows Firewall with Advanced Security</a> API is recommended.]

The <b>NET_FW_POLICY_TYPE</b> enumerated type specifies the type of policy.


## -enum-fields




### -field NET_FW_POLICY_GROUP

Policy type is group.


### -field NET_FW_POLICY_LOCAL

Policy type is local.


### -field NET_FW_POLICY_EFFECTIVE

Policy type is effective.


### -field NET_FW_POLICY_TYPE_MAX

Used for boundary checking only. Not valid for application programming.


## -see-also




<a href="https://docs.microsoft.com/previous-versions/windows/desktop/ics/windows-firewall-enumerated-types">Windows Firewall Enumerated Types</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/ics/windows-firewall-reference">Windows Firewall Reference</a>
 

 

