---
UID: NE:icftypes.NET_FW_PROFILE_TYPE_
title: NET_FW_PROFILE_TYPE (icftypes.h)
description: Specifies the type of profile.
old-location: ics\net_fw_profile_type.htm
tech.root: ics
ms.assetid: abf59405-86c7-4a20-a3e9-b12b27290b00
ms.date: 12/05/2018
ms.keywords: NET_FW_PROFILE_CURRENT, NET_FW_PROFILE_DOMAIN, NET_FW_PROFILE_STANDARD, NET_FW_PROFILE_TYPE, NET_FW_PROFILE_TYPE enumeration [ICS/ICF], NET_FW_PROFILE_TYPE_, NET_FW_PROFILE_TYPE_MAX, icftypes/NET_FW_PROFILE_CURRENT, icftypes/NET_FW_PROFILE_DOMAIN, icftypes/NET_FW_PROFILE_STANDARD, icftypes/NET_FW_PROFILE_TYPE, icftypes/NET_FW_PROFILE_TYPE_MAX, ics.net_fw_profile_type
f1_keywords:
- icftypes/NET_FW_PROFILE_TYPE
dev_langs:
- c++
req.header: icftypes.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows XP with SP2 [desktop apps only]
req.target-min-winversvr: None supported
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Icftypes.h
api_name:
- NET_FW_PROFILE_TYPE
targetos: Windows
req.typenames: NET_FW_PROFILE_TYPE
req.redist: 
ms.custom: 19H1
---

# NET_FW_PROFILE_TYPE enumeration


## -description


<p class="CCE_Message">[The Windows Firewall API is available for use in the operating systems specified in the Requirements section. It may be altered or unavailable in subsequent versions. For Windows Vista and later, use of the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/ics/windows-firewall-advanced-security-start-page">Windows Firewall with Advanced Security</a> API is recommended.]

The 
<b>NET_FW_PROFILE_TYPE</b> enumerated type  specifies the type of profile.


## -enum-fields




### -field NET_FW_PROFILE_DOMAIN

Profile type is domain.


### -field NET_FW_PROFILE_STANDARD

Profile type is standard.


### -field NET_FW_PROFILE_CURRENT

Profile type is current.


### -field NET_FW_PROFILE_TYPE_MAX

Used for boundary checking only. Not valid for application programming.


## -see-also




<a href="https://docs.microsoft.com/previous-versions/windows/desktop/ics/windows-firewall-enumerated-types">Windows Firewall Enumerated Types</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/ics/windows-firewall-reference">Windows Firewall Reference</a>
 

 

