---
UID: NE:icftypes.NET_FW_RULE_DIRECTION_
title: NET_FW_RULE_DIRECTION (icftypes.h)
description: Specifies the direction of traffic to which a rule applies.
old-location: ics\net_fw_rule_direction.htm
tech.root: ics
ms.assetid: ee60cb00-c7cb-468d-9295-002d1f87d382
ms.date: 12/05/2018
ms.keywords: NET_FW_RULE_DIRECTION, NET_FW_RULE_DIRECTION enumeration [ICS/ICF], NET_FW_RULE_DIR_IN, NET_FW_RULE_DIR_MAX, NET_FW_RULE_DIR_OUT, icftypes/NET_FW_RULE_DIRECTION, icftypes/NET_FW_RULE_DIR_IN, icftypes/NET_FW_RULE_DIR_MAX, icftypes/NET_FW_RULE_DIR_OUT, ics.net_fw_rule_direction
f1_keywords:
- icftypes/NET_FW_RULE_DIRECTION
dev_langs:
- c++
req.header: icftypes.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Icftypes.h
api_name:
- NET_FW_RULE_DIRECTION
targetos: Windows
req.typenames: NET_FW_RULE_DIRECTION
req.redist: 
ms.custom: 19H1
---

# NET_FW_RULE_DIRECTION enumeration


## -description


The <b>NET_FW_RULE_DIRECTION</b> enumerated type specifies the direction of traffic to which a rule applies.


## -enum-fields




### -field NET_FW_RULE_DIR_IN

The rule applies to inbound traffic.


### -field NET_FW_RULE_DIR_OUT

The rule applies to outbound traffic.


### -field NET_FW_RULE_DIR_MAX

This value is used for boundary checking only and is not valid for application programming.


## -see-also




<a href="https://docs.microsoft.com/previous-versions/windows/desktop/ics/windows-firewall-with-advanced-security-enumerated-types">Windows Firewall with Advanced Security Enumerated Types</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/ics/windows-firewall-with-advanced-security-reference">Windows Firewall with Advanced Security Reference</a>
 

 

