---
UID: NE:iketypes.IKEEXT_SA_ROLE_
title: IKEEXT_SA_ROLE (iketypes.h)
description: Security association (SA) role for Internet Key Exchange (IKE) and Authenticated Internet Protocol (AuthIP) Main Mode or Quick Mode negotiations.
old-location: fwp\ikeext_sa_role.htm
tech.root: fwp
ms.assetid: 6bb1e264-6141-4545-add5-e12f09769e25
ms.date: 12/05/2018
ms.keywords: IKEEXT_SA_ROLE, IKEEXT_SA_ROLE enumeration [Filtering], IKEEXT_SA_ROLE_INITIATOR, IKEEXT_SA_ROLE_MAX, IKEEXT_SA_ROLE_RESPONDER, fwp.ikeext_sa_role, iketypes/IKEEXT_SA_ROLE, iketypes/IKEEXT_SA_ROLE_INITIATOR, iketypes/IKEEXT_SA_ROLE_MAX, iketypes/IKEEXT_SA_ROLE_RESPONDER
f1_keywords:
- iketypes/IKEEXT_SA_ROLE
dev_langs:
- c++
req.header: iketypes.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Iketypes.h
api_name:
- IKEEXT_SA_ROLE
targetos: Windows
req.typenames: IKEEXT_SA_ROLE
req.redist: 
ms.custom: 19H1
---

# IKEEXT_SA_ROLE enumeration


## -description


The <b>IKEEXT_SA_ROLE</b> enumerated type defines the security association (SA) role for Internet Key Exchange (IKE) and Authenticated Internet Protocol (AuthIP) Main Mode or Quick Mode negotiations.


## -enum-fields




### -field IKEEXT_SA_ROLE_INITIATOR

SA is the initiator.


### -field IKEEXT_SA_ROLE_RESPONDER

SA is the responder.


### -field IKEEXT_SA_ROLE_MAX

Maximum value for testing purposes.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/FWP/fwp-enums">Windows Filtering Platform API Enumerated Types</a>
 

 

