---
UID: NS:iketypes.IKEEXT_INTEGRITY_ALGORITHM0_
title: IKEEXT_INTEGRITY_ALGORITHM0 (iketypes.h)
description: Stores the IKE/AuthIP hash algorithm.
old-location: fwp\ikeext_integrity_algorithm0.htm
tech.root: fwp
ms.assetid: 231d6ed9-ad41-488c-ad8b-ba64ae73f5b9
ms.date: 12/05/2018
ms.keywords: IKEEXT_INTEGRITY_ALGORITHM0, IKEEXT_INTEGRITY_ALGORITHM0 structure [Filtering], fwp.ikeext_integrity_algorithm0, iketypes/IKEEXT_INTEGRITY_ALGORITHM0
f1_keywords:
- iketypes/IKEEXT_INTEGRITY_ALGORITHM0
dev_langs:
- c++
req.header: iketypes.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Iketypes.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Iketypes.h
api_name:
- IKEEXT_INTEGRITY_ALGORITHM0
targetos: Windows
req.typenames: IKEEXT_INTEGRITY_ALGORITHM0
req.redist: 
ms.custom: 19H1
---

# IKEEXT_INTEGRITY_ALGORITHM0 structure


## -description


The <b>IKEEXT_INTEGRITY_ALGORITHM0</b> structure stores the IKE/AuthIP hash algorithm.


## -struct-fields




### -field algoIdentifier

The type of hash algorithm.

See [IKEEXT_INTEGRITY_TYPE](https://docs.microsoft.com/windows/desktop/api/iketypes/ne-iketypes-ikeext_integrity_type)a> for more information.


## -remarks



<b>IKEEXT_INTEGRITY_ALGORITHM0</b> is a specific implementation of IKEEXT_INTEGRITY_ALGORITHM. See <a href="https://docs.microsoft.com/windows/desktop/FWP/wfp-version-independent-names-and-targeting-specific-versions-of-windows">WFP Version-Independent Names and Targeting Specific Versions of Windows</a>  for more information.




## -see-also




[IKEEXT_INTEGRITY_TYPE](https://docs.microsoft.com/windows/desktop/api/iketypes/ne-iketypes-ikeext_integrity_type)a>



<a href="https://docs.microsoft.com/windows/desktop/FWP/fwp-structs">Windows Filtering Platform  API Structures</a>
 

 

