---
UID: NS:iketypes.IKEEXT_SA_DETAILS1_
title: IKEEXT_SA_DETAILS1 (iketypes.h)
description: Is used to store information returned when enumerating IKE, AuthIP, and IKEv2 security associations (SAs).
old-location: fwp\ikeext_sa_details1.htm
tech.root: fwp
ms.assetid: b4b8767b-399a-49f0-91fd-59c2206742de
ms.date: 12/05/2018
ms.keywords: IKEEXT_SA_DETAILS1, IKEEXT_SA_DETAILS1 structure [Filtering], fwp.ikeext_sa_details1, iketypes/IKEEXT_SA_DETAILS1
f1_keywords:
- iketypes/IKEEXT_SA_DETAILS1
dev_langs:
- c++
req.header: iketypes.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 7 [desktop apps only]
req.target-min-winversvr: Windows Server 2008 R2 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Iketypes.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Iketypes.h
api_name:
- IKEEXT_SA_DETAILS1
targetos: Windows
req.typenames: IKEEXT_SA_DETAILS1
req.redist: 
ms.custom: 19H1
---

# IKEEXT_SA_DETAILS1 structure


## -description


The <b>IKEEXT_SA_DETAILS1</b> structure is used to store information returned when enumerating IKE, AuthIP, and IKEv2 security associations (SAs).
[IKEEXT_SA_DETAILS0](https://docs.microsoft.com/windows/desktop/api/iketypes/ns-iketypes-ikeext_sa_details0)a> is available.</div><div> </div>

## -struct-fields




### -field saId

LUID identifying the security association.


### -field keyModuleType

Key module type. 

See [IKEEXT_KEY_MODULE_TYPE](https://docs.microsoft.com/windows/desktop/api/iketypes/ne-iketypes-ikeext_key_module_type)a> for more information. 


### -field ipVersion

IP version specified by [FWP_IP_VERSION](https://docs.microsoft.com/windows/desktop/api/fwptypes/ne-fwptypes-fwp_ip_version)a>.


### -field v4UdpEncapsulation

Points to an  [IPSEC_V4_UDP_ENCAPSULATION0](https://docs.microsoft.com/windows/desktop/api/ipsectypes/ns-ipsectypes-ipsec_v4_udp_encapsulation0)a> structure, which, if a NAT is detected,  stores the UDP ports corresponding to the 
   Main Mode.

Available when <b>ipVersion</b> is <b>FWP_IP_VERSION_V4</b>. 


### -field ikeTraffic

The traffic corresponding to this IKE SA specified by [IKEEXT_TRAFFIC0](https://docs.microsoft.com/windows/desktop/api/iketypes/ns-iketypes-ikeext_traffic0)a>.


### -field ikeProposal

The main mode proposal corresponding to this IKE SA specified by [IKEEXT_PROPOSAL0](https://docs.microsoft.com/windows/desktop/api/iketypes/ns-iketypes-ikeext_proposal0)a>.


### -field cookiePair

SA cookies specified by [IKEEXT_COOKIE_PAIR0](https://docs.microsoft.com/windows/desktop/api/iketypes/ns-iketypes-ikeext_cookie_pair0)a>.


### -field ikeCredentials

Credentials information for the SA specified by [IKEEXT_CREDENTIALS1](https://docs.microsoft.com/windows/desktop/api/iketypes/ns-iketypes-ikeext_credentials1)a>.


### -field ikePolicyKey

GUID of the main mode policy provider context corresponding to this SA.


### -field virtualIfTunnelId

ID/Handle to virtual interface tunneling state. Applicable only to IKEv2.


### -field correlationKey

 




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/FWP/fwp-structs">Windows Filtering Platform  API Structures</a>
 

 

