---
UID: NE:imapi2._IMAPI_FEATURE_PAGE_TYPE
title: IMAPI_FEATURE_PAGE_TYPE (imapi2.h)
description: Defines values for the feature that are supported by the logical unit (CD and DVD device).
old-location: imapi\imapi_feature_page_type.htm
tech.root: imapi
ms.assetid: 659ed2c9-7c58-4030-be41-273e597d6f1f
ms.date: 12/05/2018
ms.keywords: '*PIMAPI_FEATURE_PAGE_TYPE, IMAPI_FEATURE_PAGE_TYPE, IMAPI_FEATURE_PAGE_TYPE enumeration [IMAPI], IMAPI_FEATURE_PAGE_TYPE_AACS, IMAPI_FEATURE_PAGE_TYPE_BD_PSEUDO_OVERWRITE, IMAPI_FEATURE_PAGE_TYPE_BD_READ, IMAPI_FEATURE_PAGE_TYPE_BD_WRITE, IMAPI_FEATURE_PAGE_TYPE_CDRW_CAV_WRITE, IMAPI_FEATURE_PAGE_TYPE_CD_ANALOG_PLAY, IMAPI_FEATURE_PAGE_TYPE_CD_MASTERING, IMAPI_FEATURE_PAGE_TYPE_CD_MULTIREAD, IMAPI_FEATURE_PAGE_TYPE_CD_READ, IMAPI_FEATURE_PAGE_TYPE_CD_RW_MEDIA_WRITE_SUPPORT, IMAPI_FEATURE_PAGE_TYPE_CD_TRACK_AT_ONCE, IMAPI_FEATURE_PAGE_TYPE_CORE, IMAPI_FEATURE_PAGE_TYPE_DISC_CONTROL_BLOCKS, IMAPI_FEATURE_PAGE_TYPE_DOUBLE_DENSITY_CD_READ, IMAPI_FEATURE_PAGE_TYPE_DOUBLE_DENSITY_CD_RW_WRITE, IMAPI_FEATURE_PAGE_TYPE_DOUBLE_DENSITY_CD_R_WRITE, IMAPI_FEATURE_PAGE_TYPE_DVD_CPRM, IMAPI_FEATURE_PAGE_TYPE_DVD_CSS, IMAPI_FEATURE_PAGE_TYPE_DVD_DASH_WRITE, IMAPI_FEATURE_PAGE_TYPE_DVD_PLUS_R, IMAPI_FEATURE_PAGE_TYPE_DVD_PLUS_RW, IMAPI_FEATURE_PAGE_TYPE_DVD_PLUS_R_DUAL_LAYER, IMAPI_FEATURE_PAGE_TYPE_DVD_READ, IMAPI_FEATURE_PAGE_TYPE_EMBEDDED_CHANGER, IMAPI_FEATURE_PAGE_TYPE_ENHANCED_DEFECT_REPORTING, IMAPI_FEATURE_PAGE_TYPE_FIRMWARE_INFORMATION, IMAPI_FEATURE_PAGE_TYPE_FORMATTABLE, IMAPI_FEATURE_PAGE_TYPE_HARDWARE_DEFECT_MANAGEMENT, IMAPI_FEATURE_PAGE_TYPE_HD_DVD_READ, IMAPI_FEATURE_PAGE_TYPE_HD_DVD_WRITE, IMAPI_FEATURE_PAGE_TYPE_INCREMENTAL_STREAMING_WRITABLE, IMAPI_FEATURE_PAGE_TYPE_LAYER_JUMP_RECORDING, IMAPI_FEATURE_PAGE_TYPE_LOGICAL_UNIT_SERIAL_NUMBER, IMAPI_FEATURE_PAGE_TYPE_MEDIA_SERIAL_NUMBER, IMAPI_FEATURE_PAGE_TYPE_MICROCODE_UPDATE, IMAPI_FEATURE_PAGE_TYPE_MORPHING, IMAPI_FEATURE_PAGE_TYPE_MRW, IMAPI_FEATURE_PAGE_TYPE_POWER_MANAGEMENT, IMAPI_FEATURE_PAGE_TYPE_PROFILE_LIST, IMAPI_FEATURE_PAGE_TYPE_RANDOMLY_READABLE, IMAPI_FEATURE_PAGE_TYPE_RANDOMLY_WRITABLE, IMAPI_FEATURE_PAGE_TYPE_REAL_TIME_STREAMING, IMAPI_FEATURE_PAGE_TYPE_REMOVABLE_MEDIUM, IMAPI_FEATURE_PAGE_TYPE_RESTRICTED_OVERWRITE, IMAPI_FEATURE_PAGE_TYPE_RIGID_RESTRICTED_OVERWRITE, IMAPI_FEATURE_PAGE_TYPE_SECTOR_ERASABLE, IMAPI_FEATURE_PAGE_TYPE_SMART, IMAPI_FEATURE_PAGE_TYPE_TIMEOUT, IMAPI_FEATURE_PAGE_TYPE_VCPS, IMAPI_FEATURE_PAGE_TYPE_WRITE_ONCE, IMAPI_FEATURE_PAGE_TYPE_WRITE_PROTECT, PIMAPI_FEATURE_PAGE_TYPE, PIMAPI_FEATURE_PAGE_TYPE enumeration pointer [IMAPI], imapi.imapi_feature_page_type, imapi2/IMAPI_FEATURE_PAGE_TYPE, imapi2/IMAPI_FEATURE_PAGE_TYPE_AACS, imapi2/IMAPI_FEATURE_PAGE_TYPE_BD_PSEUDO_OVERWRITE, imapi2/IMAPI_FEATURE_PAGE_TYPE_BD_READ, imapi2/IMAPI_FEATURE_PAGE_TYPE_BD_WRITE, imapi2/IMAPI_FEATURE_PAGE_TYPE_CDRW_CAV_WRITE, imapi2/IMAPI_FEATURE_PAGE_TYPE_CD_ANALOG_PLAY, imapi2/IMAPI_FEATURE_PAGE_TYPE_CD_MASTERING, imapi2/IMAPI_FEATURE_PAGE_TYPE_CD_MULTIREAD, imapi2/IMAPI_FEATURE_PAGE_TYPE_CD_READ, imapi2/IMAPI_FEATURE_PAGE_TYPE_CD_RW_MEDIA_WRITE_SUPPORT, imapi2/IMAPI_FEATURE_PAGE_TYPE_CD_TRACK_AT_ONCE, imapi2/IMAPI_FEATURE_PAGE_TYPE_CORE, imapi2/IMAPI_FEATURE_PAGE_TYPE_DISC_CONTROL_BLOCKS, imapi2/IMAPI_FEATURE_PAGE_TYPE_DOUBLE_DENSITY_CD_READ, imapi2/IMAPI_FEATURE_PAGE_TYPE_DOUBLE_DENSITY_CD_RW_WRITE, imapi2/IMAPI_FEATURE_PAGE_TYPE_DOUBLE_DENSITY_CD_R_WRITE, imapi2/IMAPI_FEATURE_PAGE_TYPE_DVD_CPRM, imapi2/IMAPI_FEATURE_PAGE_TYPE_DVD_CSS, imapi2/IMAPI_FEATURE_PAGE_TYPE_DVD_DASH_WRITE, imapi2/IMAPI_FEATURE_PAGE_TYPE_DVD_PLUS_R, imapi2/IMAPI_FEATURE_PAGE_TYPE_DVD_PLUS_RW, imapi2/IMAPI_FEATURE_PAGE_TYPE_DVD_PLUS_R_DUAL_LAYER, imapi2/IMAPI_FEATURE_PAGE_TYPE_DVD_READ, imapi2/IMAPI_FEATURE_PAGE_TYPE_EMBEDDED_CHANGER, imapi2/IMAPI_FEATURE_PAGE_TYPE_ENHANCED_DEFECT_REPORTING, imapi2/IMAPI_FEATURE_PAGE_TYPE_FIRMWARE_INFORMATION, imapi2/IMAPI_FEATURE_PAGE_TYPE_FORMATTABLE, imapi2/IMAPI_FEATURE_PAGE_TYPE_HARDWARE_DEFECT_MANAGEMENT, imapi2/IMAPI_FEATURE_PAGE_TYPE_HD_DVD_READ, imapi2/IMAPI_FEATURE_PAGE_TYPE_HD_DVD_WRITE, imapi2/IMAPI_FEATURE_PAGE_TYPE_INCREMENTAL_STREAMING_WRITABLE, imapi2/IMAPI_FEATURE_PAGE_TYPE_LAYER_JUMP_RECORDING, imapi2/IMAPI_FEATURE_PAGE_TYPE_LOGICAL_UNIT_SERIAL_NUMBER, imapi2/IMAPI_FEATURE_PAGE_TYPE_MEDIA_SERIAL_NUMBER, imapi2/IMAPI_FEATURE_PAGE_TYPE_MICROCODE_UPDATE, imapi2/IMAPI_FEATURE_PAGE_TYPE_MORPHING, imapi2/IMAPI_FEATURE_PAGE_TYPE_MRW, imapi2/IMAPI_FEATURE_PAGE_TYPE_POWER_MANAGEMENT, imapi2/IMAPI_FEATURE_PAGE_TYPE_PROFILE_LIST, imapi2/IMAPI_FEATURE_PAGE_TYPE_RANDOMLY_READABLE, imapi2/IMAPI_FEATURE_PAGE_TYPE_RANDOMLY_WRITABLE, imapi2/IMAPI_FEATURE_PAGE_TYPE_REAL_TIME_STREAMING, imapi2/IMAPI_FEATURE_PAGE_TYPE_REMOVABLE_MEDIUM, imapi2/IMAPI_FEATURE_PAGE_TYPE_RESTRICTED_OVERWRITE, imapi2/IMAPI_FEATURE_PAGE_TYPE_RIGID_RESTRICTED_OVERWRITE, imapi2/IMAPI_FEATURE_PAGE_TYPE_SECTOR_ERASABLE, imapi2/IMAPI_FEATURE_PAGE_TYPE_SMART, imapi2/IMAPI_FEATURE_PAGE_TYPE_TIMEOUT, imapi2/IMAPI_FEATURE_PAGE_TYPE_VCPS, imapi2/IMAPI_FEATURE_PAGE_TYPE_WRITE_ONCE, imapi2/IMAPI_FEATURE_PAGE_TYPE_WRITE_PROTECT, imapi2/PIMAPI_FEATURE_PAGE_TYPE'
f1_keywords:
- imapi2/IMAPI_FEATURE_PAGE_TYPE
dev_langs:
- c++
req.header: imapi2.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista, Windows XP with SP2 [desktop apps only]
req.target-min-winversvr: Windows Server 2003 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Imapi2.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- imapi2.h
api_name:
- IMAPI_FEATURE_PAGE_TYPE
targetos: Windows
req.typenames: IMAPI_FEATURE_PAGE_TYPE, *PIMAPI_FEATURE_PAGE_TYPE
req.redist: 
ms.custom: 19H1
---

# IMAPI_FEATURE_PAGE_TYPE enumeration


## -description


Defines values for the feature that are supported by the logical unit (CD and DVD device).  


## -enum-fields




### -field IMAPI_FEATURE_PAGE_TYPE_PROFILE_LIST

 Identifies profiles supported by the logical unit.


### -field IMAPI_FEATURE_PAGE_TYPE_CORE

 Identifies a logical unit that supports functionality common to all devices.


### -field IMAPI_FEATURE_PAGE_TYPE_MORPHING

Identifies the ability of the logical unit to notify an initiator about operational changes 
and accept initiator requests to prevent operational changes.


### -field IMAPI_FEATURE_PAGE_TYPE_REMOVABLE_MEDIUM

Identifies a logical unit that has a medium that is removable.


### -field IMAPI_FEATURE_PAGE_TYPE_WRITE_PROTECT

 Identifies reporting capability and changing capability for write protection status of the 
logical unit.


### -field IMAPI_FEATURE_PAGE_TYPE_RANDOMLY_READABLE

 Identifies a logical unit that is able to read data from logical blocks specified by Logical 
Block Addresses.


### -field IMAPI_FEATURE_PAGE_TYPE_CD_MULTIREAD

Identifies a logical unit that conforms to the OSTA Multi-Read specification 1.00, with the exception of CD 
Play capability (the CD Audio Feature is not required).


### -field IMAPI_FEATURE_PAGE_TYPE_CD_READ

 Identifies a logical unit that is able to read CD specific information from the media and 
is able to read user data from all types of CD blocks.


### -field IMAPI_FEATURE_PAGE_TYPE_DVD_READ

 Identifies a logical unit that is able to read DVD specific information from the media.


### -field IMAPI_FEATURE_PAGE_TYPE_RANDOMLY_WRITABLE

Identifies a logical unit that is able to write data to logical blocks specified by Logical 
Block Addresses. 


### -field IMAPI_FEATURE_PAGE_TYPE_INCREMENTAL_STREAMING_WRITABLE

 Identifies a logical unit that is able to write data to a contiguous region, and is able to 
append data to a limited number of locations on the media.


### -field IMAPI_FEATURE_PAGE_TYPE_SECTOR_ERASABLE

 Identifies a logical unit that supports erasable media and media that requires an erase 
pass before overwrite, such as some magneto-optical technologies.


### -field IMAPI_FEATURE_PAGE_TYPE_FORMATTABLE

 Identifies a logical unit that can format media into logical blocks.


### -field IMAPI_FEATURE_PAGE_TYPE_HARDWARE_DEFECT_MANAGEMENT

Identifies a logical unit that has defect management available to provide a 
defect-free contiguous address space.


### -field IMAPI_FEATURE_PAGE_TYPE_WRITE_ONCE

Identifies a logical unit that has the ability to record to any previously unrecorded 
logical block.


### -field IMAPI_FEATURE_PAGE_TYPE_RESTRICTED_OVERWRITE

 Identifies a logical unit that has the ability to overwrite logical blocks only in fixed 
sets at a time. 


### -field IMAPI_FEATURE_PAGE_TYPE_CDRW_CAV_WRITE

Identifies a logical unit that has the ability to write CD-RW media that is designed for 
CAV recording. 


### -field IMAPI_FEATURE_PAGE_TYPE_MRW

 Indicates that the logical unit is capable of reading a disc with the 
MRW format.


### -field IMAPI_FEATURE_PAGE_TYPE_ENHANCED_DEFECT_REPORTING

 Identifies a logical unit that has the ability to perform media 
certification and recovered error reporting for logical unit assisted software defect 
management.


### -field IMAPI_FEATURE_PAGE_TYPE_DVD_PLUS_RW

 Indicates that the logical unit is capable of reading a 
recorded DVD+RW disc.


### -field IMAPI_FEATURE_PAGE_TYPE_DVD_PLUS_R

 Indicates that the logical unit is capable of reading a recorded 
DVD+R disc.


### -field IMAPI_FEATURE_PAGE_TYPE_RIGID_RESTRICTED_OVERWRITE

Identifies a logical unit that has the ability to perform writing only on Blocking 
boundaries. 


### -field IMAPI_FEATURE_PAGE_TYPE_CD_TRACK_AT_ONCE

Identifies a logical unit that is able to write data to a CD track.


### -field IMAPI_FEATURE_PAGE_TYPE_CD_MASTERING

Identifies a logical unit that is able to write a CD in Session at Once mode or Raw mode.


### -field IMAPI_FEATURE_PAGE_TYPE_DVD_DASH_WRITE

 Identifies a logical unit that has the ability to write data to DVD-R/-RW in Disc at Once 
mode. 


### -field IMAPI_FEATURE_PAGE_TYPE_DOUBLE_DENSITY_CD_READ

Identifies a logical unit that has the ability to read double density CD specific information from the media.

<div class="alert"><b>Note</b>  This value has been deprecated.</div>
<div> </div>

### -field IMAPI_FEATURE_PAGE_TYPE_DOUBLE_DENSITY_CD_R_WRITE

Identifies a logical unit that has the ability to write to double density CD  media.

<div class="alert"><b>Note</b>  This value has been deprecated.</div>
<div> </div>

### -field IMAPI_FEATURE_PAGE_TYPE_DOUBLE_DENSITY_CD_RW_WRITE

Identifies a logical unit that has the ability to write to double density CD-RW  media.

<div class="alert"><b>Note</b>  This value has been deprecated.</div>
<div> </div>

### -field IMAPI_FEATURE_PAGE_TYPE_LAYER_JUMP_RECORDING

Identifies a drive that is able to write data to contiguous regions that are allocated on multiple
layers, and is able to append data to a limited number of locations on the media.


### -field IMAPI_FEATURE_PAGE_TYPE_CD_RW_MEDIA_WRITE_SUPPORT

 Identifies a logical unit that has the ability to perform writing CD-RW media.


### -field IMAPI_FEATURE_PAGE_TYPE_BD_PSEUDO_OVERWRITE

Identifies a drive that provides Logical Block overwrite service on BD-R discs that are
formatted as SRM+POW.


### -field IMAPI_FEATURE_PAGE_TYPE_DVD_PLUS_R_DUAL_LAYER

 Indicates that the drive is capable of reading a 
recorded DVD+R Double Layer disc


### -field IMAPI_FEATURE_PAGE_TYPE_BD_READ

Identifies a logical unit that is able to read control structures and user data from the Blu-ray 
disc. 


### -field IMAPI_FEATURE_PAGE_TYPE_BD_WRITE

Identifies a drive that is able to write control structures and user data to writeable Blu-ray discs.


### -field IMAPI_FEATURE_PAGE_TYPE_HD_DVD_READ

Identifies a drive that is able to read HD DVD specific information from the media.


### -field IMAPI_FEATURE_PAGE_TYPE_HD_DVD_WRITE

Indicates the ability to write to HD DVD-R/-RW media.


### -field IMAPI_FEATURE_PAGE_TYPE_POWER_MANAGEMENT

 Identifies a logical unit that is able to perform initiator and logical unit directed power 
management.


### -field IMAPI_FEATURE_PAGE_TYPE_SMART

Identifies a logical unit that is able to perform Self-Monitoring Analysis and Reporting 
Technology (S.M.A.R.T.). 


### -field IMAPI_FEATURE_PAGE_TYPE_EMBEDDED_CHANGER

 Identifies a logical unit that is able to move media from a storage area to a mechanism 
and back.


### -field IMAPI_FEATURE_PAGE_TYPE_CD_ANALOG_PLAY

 Identifies a logical unit that is able to play CD Audio data directly to an external output.


### -field IMAPI_FEATURE_PAGE_TYPE_MICROCODE_UPDATE

Identifies a logical unit that is able to upgrade its internal microcode via the interface.


### -field IMAPI_FEATURE_PAGE_TYPE_TIMEOUT

 Identifies a logical unit that is able to always respond to commands within a set time 
period.


### -field IMAPI_FEATURE_PAGE_TYPE_DVD_CSS

Identifies a logical unit that is able to perform DVD CSS/CPPM authentication and key 
management. This feature also indicates that the logical unit supports CSS for DVD-Video and CPPM for 
DVD-Audio. 


### -field IMAPI_FEATURE_PAGE_TYPE_REAL_TIME_STREAMING

Identifies a logical unit that is able to perform reading and writing within initiator 
specified (and logical unit verified) performance ranges.  This Feature also indicates whether the 
logical unit supports the stream playback operation.


### -field IMAPI_FEATURE_PAGE_TYPE_LOGICAL_UNIT_SERIAL_NUMBER

 Identifies a logical unit that has a unique serial number.


### -field IMAPI_FEATURE_PAGE_TYPE_MEDIA_SERIAL_NUMBER

Identifies a logical unit that is capable of reading a media serial number of the currently 
installed media.


### -field IMAPI_FEATURE_PAGE_TYPE_DISC_CONTROL_BLOCKS

 Identifies a logical unit that is able to read and/or write Disc Control Blocks from or to 
the media.


### -field IMAPI_FEATURE_PAGE_TYPE_DVD_CPRM

 Identifies a logical unit that is able to perform DVD CPRM and is able to perform CPRM 
authentication and key management.


### -field IMAPI_FEATURE_PAGE_TYPE_FIRMWARE_INFORMATION

 Indicates that the logical unit provides the date and time of the creation of the 
current firmware revision loaded on the device. 


### -field IMAPI_FEATURE_PAGE_TYPE_AACS

Identifies a drive that supports AACS and is able to perform AACS authentication process.


### -field IMAPI_FEATURE_PAGE_TYPE_VCPS

Identifies a Drive that is able to process disc data structures that are specified in the
VCPS.


## -remarks



Note that the range of feature type values is 0x0000 to 0xFFFF. This enumeration contains those features defined in the Multmedia Commands - 5 (MMC) specification. For a complete definition of each feature, see Feature Definitions in the latest release of the MMC specification at ftp://ftp.t10.org/t10/drafts/mmc5.

Other values not defined here may exist. Consumers of this enumeration should not presume this list to be the only set of valid values.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/imapi2/nf-imapi2-idiscrecorder2-get_supportedfeaturepages">IDiscRecorder2::get_SupportedFeaturePages</a>



<a href="https://docs.microsoft.com/windows/desktop/api/imapi2/nf-imapi2-idiscrecorder2ex-getfeaturepage">IDiscRecorder2Ex::GetFeaturePage</a>



<a href="https://docs.microsoft.com/windows/desktop/api/imapi2/nf-imapi2-idiscrecorder2ex-getsupportedfeaturepages">IDiscRecorder2Ex::GetSupportedFeaturePages</a>
 

 

