---
UID: NF:imapi2.IBurnVerification.put_BurnVerificationLevel
title: IBurnVerification::put_BurnVerificationLevel (imapi2.h)
description: Sets the Burn Verification Level.
old-location: imapi\iburnverification_put_burnverificationlevel.htm
tech.root: imapi
ms.assetid: 71842038-91dc-4de5-8169-3bc97ef288c6
ms.date: 12/05/2018
ms.keywords: IBurnVerification interface [IMAPI],put_BurnVerificationLevel method, IBurnVerification.put_BurnVerificationLevel, IBurnVerification::put_BurnVerificationLevel, imapi.iburnverification_put_burnverificationlevel, imapi2/IBurnVerification::put_BurnVerificationLevel, put_BurnVerificationLevel, put_BurnVerificationLevel method [IMAPI], put_BurnVerificationLevel method [IMAPI],IBurnVerification interface
f1_keywords:
- imapi2/IBurnVerification.put_BurnVerificationLevel
dev_langs:
- c++
req.header: imapi2.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista, Windows XP with SP2 [desktop apps only]
req.target-min-winversvr: Windows Server 2003 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Imapi2.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- imapi2.h
api_name:
- IBurnVerification.put_BurnVerificationLevel
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IBurnVerification::put_BurnVerificationLevel


## -description


Sets the   Burn Verification Level.


## -parameters




### -param value

Value that defines the Burn Verification Level. For possible values, see <a href="https://docs.microsoft.com/windows/desktop/api/imapi2/ne-imapi2-imapi_burn_verification_level">IMAPI_BURN_VERIFICATION_LEVEL</a>.


## -returns



S_OK is returned on success, but other success codes may be returned as a result of implementation.




## -remarks



This method is supported in Windows Server 2003 with Service Pack 1 (SP1), Windows XP with Service Pack 2 (SP2),  and Windows Vista  via the Windows Feature Pack for Storage. All  features provided by this  update package are supported natively in Windows 7 and Windows Server 2008 R2.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/imapi2/nn-imapi2-iburnverification">IBurnVerification</a>



<a href="https://docs.microsoft.com/windows/desktop/api/imapi2/ne-imapi2-imapi_burn_verification_level">IMAPI_BURN_VERIFICATION_LEVEL</a>
 

 

