---
UID: NF:imapi2.IRawCDImageCreator.put_ResultingImageType
title: IRawCDImageCreator::put_ResultingImageType (imapi2.h)
description: Sets the value that defines the type of image file that will be generated.
old-location: imapi\irawcdimagecreator_put_resultingimagetype.htm
tech.root: imapi
ms.assetid: 1800717a-3b8a-45b2-849b-55c37d3b1b32
ms.date: 12/05/2018
ms.keywords: IRawCDImageCreator interface [IMAPI],put_ResultingImageType method, IRawCDImageCreator.put_ResultingImageType, IRawCDImageCreator::put_ResultingImageType, imapi.irawcdimagecreator_put_resultingimagetype, imapi2/IRawCDImageCreator::put_ResultingImageType, put_ResultingImageType, put_ResultingImageType method [IMAPI], put_ResultingImageType method [IMAPI],IRawCDImageCreator interface
f1_keywords:
- imapi2/IRawCDImageCreator.put_ResultingImageType
dev_langs:
- c++
req.header: imapi2.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista, Windows XP with SP2 [desktop apps only]
req.target-min-winversvr: Windows Server 2003 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Imapi2.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- imapi2.h
api_name:
- IRawCDImageCreator.put_ResultingImageType
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IRawCDImageCreator::put_ResultingImageType


## -description


Sets the value that defines the type of image file that will be generated.


## -parameters




### -param value [in]

An <a href="https://docs.microsoft.com/windows/win32/api/imapi2/ne-imapi2-imapi_format2_raw_cd_data_sector_type">IMAPI_FORMAT2_RAW_CD_DATA_SECTOR_TYPE</a> enumeration that defines the type of image file.


## -returns



S_OK is returned on success, but other success codes may be returned as a result of implementation.




## -remarks



If the value set via <a href="https://docs.microsoft.com/windows/win32/api/imapi2/ne-imapi2-imapi_format2_raw_cd_data_sector_type">IRawCDImageCreator::AddSubcodeRWGenerator</a> is not <b>NULL</b>, then the <b>PQ_ONLY</b> type defined by <a href="https://docs.microsoft.com/windows/desktop/api/imapi2/ne-imapi2-imapi_format2_raw_cd_data_sector_type">IMAPI_FORMAT2_RAW_CD_DATA_SECTOR_TYPE</a> is not a valid choice, as subcode would not be generated by the resulting image.

This method is supported in Windows Server 2003 with Service Pack 1 (SP1), Windows XP with Service Pack 2 (SP2),  and Windows Vista  via the Windows Feature Pack for Storage. All  features provided by this  update package are supported natively in Windows 7 and Windows Server 2008 R2.




## -see-also




<a href="https://docs.microsoft.com/windows/win32/api/imapi2/ne-imapi2-imapi_format2_raw_cd_data_sector_type">IMAPI_FORMAT2_RAW_CD_DATA_SECTOR_TYPE</a>



<a href="https://docs.microsoft.com/windows/desktop/api/imapi2/nn-imapi2-irawcdimagecreator">IRawCDImageCreator</a>



<a href="https://docs.microsoft.com/windows/desktop/api/imapi2/nf-imapi2-irawcdimagecreator-addsubcoderwgenerator">IRawCDImageCreator::AddSubcodeRWGenerator</a>



<a href="https://docs.microsoft.com/windows/desktop/api/imapi2/nf-imapi2-irawcdimagecreator-get_resultingimagetype">IRawCDImageCreator::get_ResultingImageType</a>
 

 

