---
UID: NF:indexsrv.IStemmer.GenerateWordForms
title: IStemmer::GenerateWordForms (indexsrv.h)
description: Generates alternative forms for a word and puts these forms in the IWordFormSink object.
old-location: search\_search_IStemmer_GenerateWordForms.htm
tech.root: search
ms.assetid: VS|search|~\search\wds3x\reference\ifaces\dataaddins\istemmer\generatewordforms.htm
ms.date: 12/05/2018
ms.keywords: GenerateWordForms, GenerateWordForms method [search], GenerateWordForms method [search],IStemmer interface, IStemmer interface [search],GenerateWordForms method, IStemmer.GenerateWordForms, IStemmer::GenerateWordForms, _search_IStemmer_GenerateWordForms, indexsrv/IStemmer::GenerateWordForms, search._search_IStemmer_GenerateWordForms
f1_keywords:
- indexsrv/IStemmer.GenerateWordForms
dev_langs:
- c++
req.header: indexsrv.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- Indexsrv.h
api_name:
- IStemmer.GenerateWordForms
targetos: Windows
req.typenames: 
req.redist: Windows NT 4.0 Option Pack
ms.custom: 19H1
---

# IStemmer::GenerateWordForms


## -description


Generates alternative forms for a word and puts these forms in the <a href="https://docs.microsoft.com/windows/desktop/api/indexsrv/nn-indexsrv-iwordformsink">IWordFormSink</a> object.


## -parameters




### -param pwcInBuf [in]

Type: <b>const WCHAR*</b>

Pointer to a buffer that contains the word to stem. The characters in <i>pwcInBuf</i> are represented in Unicode.


### -param cwc [in]

Type: <b>ULONG</b>

Number of characters in <i>pwcInBuf</i>.


### -param pStemSink [in]

Type: <b>IWordFormSink*</b>

Pointer to an <a href="https://docs.microsoft.com/windows/desktop/api/indexsrv/nn-indexsrv-iwordformsink">IWordFormSink</a> object that receives and handles the alternative word forms generated by this method.


## -returns



Type: <b>HRESULT</b>

This method can return one of these values.

<table>
<tr>
<th>Return code</th>
<th>Description</th>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>S_OK</b></dt>
</dl>
</td>
<td width="60%">
Successful completion.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>E_INVALIDARG</b></dt>
</dl>
</td>
<td width="60%">
Invalid argument. Either <i>pwcInBuf</i> or <i>pWordFormSink</i> is <b>NULL</b>.

</td>
</tr>
</table>
 




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/indexsrv/nn-indexsrv-istemmer">IStemmer</a>
 

 

