---
UID: NF:indexsrv.IWordBreaker.BreakText
title: IWordBreaker::BreakText (indexsrv.h)
description: Parses text to identify words and phrases and provides the results to the IWordSink and IPhraseSink objects.
old-location: search\_search_IWordBreaker_BreakText.htm
tech.root: search
ms.assetid: VS|search|~\search\wds3x\reference\ifaces\dataaddins\iwordbreaker\breaktext.htm
ms.date: 12/05/2018
ms.keywords: BreakText, BreakText method [search], BreakText method [search],IWordBreaker interface, IWordBreaker interface [search],BreakText method, IWordBreaker.BreakText, IWordBreaker::BreakText, _search_IWordBreaker_BreakText, indexsrv/IWordBreaker::BreakText, search._search_IWordBreaker_BreakText
f1_keywords:
- indexsrv/IWordBreaker.BreakText
dev_langs:
- c++
req.header: indexsrv.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- Indexsrv.h
api_name:
- IWordBreaker.BreakText
targetos: Windows
req.typenames: 
req.redist: Windows NT 4.0 Option Pack
ms.custom: 19H1
---

# IWordBreaker::BreakText


## -description


Parses text to identify words and phrases and provides the results to the <a href="https://docs.microsoft.com/windows/desktop/search/iwordsink">IWordSink</a> and <a href="https://docs.microsoft.com/windows/desktop/api/indexsrv/nn-indexsrv-iphrasesink">IPhraseSink</a> objects.


## -parameters




### -param pTextSource [in]

Type: <b><a href="https://docs.microsoft.com/windows/desktop/api/indexsrv/ns-indexsrv-text_source">TEXT_SOURCE</a>*</b>

Pointer to a <a href="https://docs.microsoft.com/windows/desktop/api/indexsrv/ns-indexsrv-text_source">TEXT_SOURCE</a> structure that contains Unicode text.


### -param pWordSink [in]

Type: <b>IWordSink*</b>

Pointer to the <a href="https://docs.microsoft.com/windows/desktop/search/iwordsink">IWordSink</a> object that receives and handles words generated by this method. <b>NULL</b> indicates that this method should identify phrases only.


### -param pPhraseSink [in]

Type: <b>IPhraseSink*</b>

Pointer to the <a href="https://docs.microsoft.com/windows/desktop/api/indexsrv/nn-indexsrv-iphrasesink">IPhraseSink</a> object that receives and handles phrases generated by this method. <b>NULL</b> indicates that this method should identify individual words, not phrases. 


## -returns



Type: <b>HRESULT</b>

This method can return one of these values.

<table>
<tr>
<th>Return code</th>
<th>Description</th>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>S_OK</b></dt>
</dl>
</td>
<td width="60%">
Operation was successful. No more text is available to refill the <i>pTextSource</i> buffer.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>E_INVALIDARG</b></dt>
</dl>
</td>
<td width="60%">
Invalid argument. The <i>pTextSource</i> parameter is <b>NULL</b>.

</td>
</tr>
</table>
 




## -remarks



Because word breakers more commonly parse for words than phrases, you should optimize for <i>pPhraseSink</i> = 0. Either <i>pWordSink</i> or <i>pPhraseSink</i> can be <b>NULL</b>, but not both.

The <a href="https://docs.microsoft.com/windows/desktop/search/iwordsink">IWordSink</a> object holds the words and their alternative forms for the word breaker. Alternative forms of words, if they exist, are put in the <b>IWordSink</b> object first, by using the <b>WordSink::PutAltWord</b> method, and the root word is added last, by using the <b>WordSink::PutWord</b> method.

Use <b>pfnFillTextBuffer</b>, the function pointer element in the <a href="https://docs.microsoft.com/windows/desktop/api/indexsrv/ns-indexsrv-text_source">TEXT_SOURCE</a> structure, to replenish the source text. The <b>IWordBreaker::BreakText</b> method must handle all <b>pfnFillTextBuffer</b> return values. If an error occurs, finish processing the text in the buffer before handling the error.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/indexsrv/nn-indexsrv-iwordbreaker">IWordBreaker</a>



<a href="https://docs.microsoft.com/windows/desktop/api/indexsrv/ns-indexsrv-text_source">TEXT_SOURCE</a>
 

 

