---
UID: NE:inked.AppearanceConstants
title: AppearanceConstants (inked.h)
description: Specifies how an InkEdit control appears on the screen.
old-location: tablet\appearanceconstants.htm
tech.root: tablet
ms.assetid: 1ec00514-49d0-40dc-a9cf-8ec7d9e6a816
ms.date: 12/05/2018
ms.keywords: 1ec00514-49d0-40dc-a9cf-8ec7d9e6a816, AppearanceConstants, AppearanceConstants enumeration [Tablet PC], inked/AppearanceConstants, inked/rtfFlat, inked/rtfThreeD, rtfFlat, rtfThreeD, tablet.appearanceconstants
f1_keywords:
- inked/AppearanceConstants
dev_langs:
- c++
req.header: inked.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows XP Tablet PC Edition [desktop apps only]
req.target-min-winversvr: None supported
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- inked.h
api_name:
- AppearanceConstants
targetos: Windows
req.typenames: AppearanceConstants
req.redist: 
ms.custom: 19H1
---

# AppearanceConstants enumeration


## -description



Specifies how an <a href="https://docs.microsoft.com/windows/desktop/tablet/inkedit-control-reference">InkEdit</a> control appears on the screen.




## -enum-fields




### -field rtfFlat

Flat. Paints without visual effects.


### -field rtfThreeD

Default. 3D. Paints with three-dimensional effects.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/tablet/inkedit-control-reference">InkEdit Control Reference</a>
 

 

