---
UID: NE:inked.BorderStyleConstants
title: BorderStyleConstants (inked.h)
description: Specifies how the borders of an InkEdit control appear on the screen.
old-location: tablet\borderstyleconstants.htm
tech.root: tablet
ms.assetid: 0bb4ff9b-3024-4563-a654-5bc9ed8e0520
ms.date: 12/05/2018
ms.keywords: 0bb4ff9b-3024-4563-a654-5bc9ed8e0520, BorderStyleConstants, BorderStyleConstants enumeration [Tablet PC], inked/BorderStyleConstants, inked/rtfFixedSingle, inked/rtfNoBorder, rtfFixedSingle, rtfNoBorder, tablet.borderstyleconstants
f1_keywords:
- inked/BorderStyleConstants
dev_langs:
- c++
req.header: inked.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows XP Tablet PC Edition [desktop apps only]
req.target-min-winversvr: None supported
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- inked.h
api_name:
- BorderStyleConstants
targetos: Windows
req.typenames: BorderStyleConstants
req.redist: 
ms.custom: 19H1
---

# BorderStyleConstants enumeration


## -description



Specifies how the borders of an <a href="https://docs.microsoft.com/windows/desktop/tablet/inkedit-control-reference">InkEdit</a> control appear on the screen.




## -enum-fields




### -field rtfNoBorder

No border.


### -field rtfFixedSingle

Single line border.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/tablet/inkedit-control-reference">InkEdit Control Reference</a>
 

 

