---
UID: NE:inked.InkInsertMode
title: InkInsertMode (inked.h)
description: Specifies how ink is inserted onto the InkEdit control.
old-location: tablet\inkinsertmode.htm
tech.root: tablet
ms.assetid: ab15cf9f-c3c8-4cdb-9350-ffa734e4da35
ms.date: 12/05/2018
ms.keywords: IEM_InsertAsInk, IEM_InsertAsText, InkInsertMode, InkInsertMode enumeration [Tablet PC], ab15cf9f-c3c8-4cdb-9350-ffa734e4da35, inked/IEM_InsertAsInk, inked/IEM_InsertAsText, inked/InkInsertMode, tablet.inkinsertmode
f1_keywords:
- inked/InkInsertMode
dev_langs:
- c++
req.header: inked.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows XP Tablet PC Edition [desktop apps only]
req.target-min-winversvr: None supported
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- inked.h
api_name:
- InkInsertMode
targetos: Windows
req.typenames: InkInsertMode
req.redist: 
ms.custom: 19H1
---

# InkInsertMode enumeration


## -description



Specifies how ink is inserted onto the <a href="https://docs.microsoft.com/windows/desktop/tablet/inkedit-control-reference">InkEdit</a> control.




## -enum-fields




### -field IEM_InsertText


### -field IEM_InsertInk




#### - IEM_InsertAsInk

Drawn ink is inserted as ink.


#### - IEM_InsertAsText

Default. Drawn ink is inserted as text.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/tablet/inkedit-control-reference">InkEdit Control Reference</a>



<a href="https://docs.microsoft.com/windows/desktop/tablet/inkedit-messages--win32-only-">InkEdit Messages (Win32 Only)</a>



<a href="https://docs.microsoft.com/windows/desktop/api/inked/nf-inked-iinkedit-get_inkinsertmode">InkInsertMode Property</a>
 

 

