---
UID: NE:inked.MouseButton
title: MouseButton (inked.h)
description: Specifies which mouse button was pressed.
old-location: tablet\mousebutton.htm
tech.root: tablet
ms.assetid: cfcbee55-3489-44da-a726-71dc615fa7f5
ms.date: 12/05/2018
ms.keywords: LEFT_BUTTON, MIDDLE_BUTTON, MouseButton, MouseButton enumeration [Tablet PC], NO_BUTTON, RIGHT_BUTTON, cfcbee55-3489-44da-a726-71dc615fa7f5, inked/LEFT_BUTTON, inked/MIDDLE_BUTTON, inked/MouseButton, inked/NO_BUTTON, inked/RIGHT_BUTTON, tablet.mousebutton
f1_keywords:
- inked/MouseButton
dev_langs:
- c++
req.header: inked.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows XP Tablet PC Edition [desktop apps only]
req.target-min-winversvr: None supported
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- inked.h
api_name:
- MouseButton
targetos: Windows
req.typenames: MouseButton
req.redist: 
ms.custom: 19H1
---

# MouseButton enumeration


## -description



Specifies which mouse button was pressed.




## -enum-fields




### -field NO_BUTTON

Default. No mouse button was pressed.


### -field LEFT_BUTTON

The left mouse button was pressed.


### -field RIGHT_BUTTON

The right mouse button was pressed.


### -field MIDDLE_BUTTON

The middle mouse button was pressed.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/tablet/inkedit-control-reference">InkEdit Control Reference</a>
 

 

