---
UID: NE:inked.ScrollBarsConstants
title: ScrollBarsConstants (inked.h)
description: Specifies how the scroll bars of an InkEdit control appear on the screen.
old-location: tablet\scrollbarsconstants.htm
tech.root: tablet
ms.assetid: d689f8ff-4ad9-4306-af2d-aaed60f33c53
ms.date: 12/05/2018
ms.keywords: ScrollBarsConstants, ScrollBarsConstants enumeration [Tablet PC], d689f8ff-4ad9-4306-af2d-aaed60f33c53, inked/ScrollBarsConstants, inked/rtfBoth, inked/rtfHorizontal, inked/rtfNone, inked/rtfVertical, rtfBoth, rtfHorizontal, rtfNone, rtfVertical, tablet.scrollbarsconstants
f1_keywords:
- inked/ScrollBarsConstants
dev_langs:
- c++
req.header: inked.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows XP Tablet PC Edition [desktop apps only]
req.target-min-winversvr: None supported
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- inked.h
api_name:
- ScrollBarsConstants
targetos: Windows
req.typenames: ScrollBarsConstants
req.redist: 
ms.custom: 19H1
---

# ScrollBarsConstants enumeration


## -description



Specifies how the scroll bars of an <a href="https://docs.microsoft.com/windows/desktop/tablet/inkedit-control-reference">InkEdit</a> control appear on the screen.




## -enum-fields




### -field rtfNone

Default. No scroll bars.


### -field rtfHorizontal

Horizontal scroll bar only.


### -field rtfVertical

Vertical scroll bar only.


### -field rtfBoth

Both horizontal and vertical scroll bars.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/tablet/inkedit-control-reference">InkEdit Control Reference</a>
 

 

