---
UID: NE:inked.SelAlignmentConstants
title: SelAlignmentConstants (inked.h)
description: Specifies the alignment of the paragraph relative to the margins of the InkEdit control.
old-location: tablet\selalignmentconstants.htm
tech.root: tablet
ms.assetid: fdf5be40-e853-43a5-b1ac-b810c31fbeb3
ms.date: 12/05/2018
ms.keywords: SelAlignmentConstants, SelAlignmentConstants enumeration [Tablet PC], fdf5be40-e853-43a5-b1ac-b810c31fbeb3, inked/SelAlignmentConstants, inked/rtfCenter, inked/rtfLeft, inked/rtfRight, rtfCenter, rtfLeft, rtfRight, tablet.selalignmentconstants
f1_keywords:
- inked/SelAlignmentConstants
dev_langs:
- c++
req.header: inked.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows XP Tablet PC Edition [desktop apps only]
req.target-min-winversvr: None supported
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- inked.h
api_name:
- SelAlignmentConstants
targetos: Windows
req.typenames: SelAlignmentConstants
req.redist: 
ms.custom: 19H1
---

# SelAlignmentConstants enumeration


## -description



Specifies the alignment of the paragraph relative to the margins of the <a href="https://docs.microsoft.com/windows/desktop/tablet/inkedit-control-reference">InkEdit</a> control.




## -enum-fields




### -field rtfLeft

Default. The paragraph is aligned along the left margin.


### -field rtfRight

The paragraph is aligned along the right margin.


### -field rtfCenter

The paragraph is centered between the left and right margins.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/tablet/inkedit-control-reference">InkEdit Control Reference</a>
 

 

