---
UID: NF:intsafe.ULongPtrToUInt
title: ULongPtrToUInt function (intsafe.h)
description: Converts a value of type ULONG_PTR to a value of type UINT.
old-location: shell\ULongPtrToUInt.htm
tech.root: shell
ms.assetid: 8b0c5cd0-cb8d-40c2-9a8d-0299074aa8a8
ms.date: 12/05/2018
ms.keywords: DWordPtrToUInt, SIZETToUInt, ULongPtrToUInt, ULongPtrToUInt function [Windows Shell], _shell_ULongPtrToUInt, intsafe/ULongPtrToUInt, shell.ULongPtrToUInt
f1_keywords:
- intsafe/ULongPtrToUInt
dev_langs:
- c++
req.header: intsafe.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Intsafe.h
api_name:
- ULongPtrToUInt
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# ULongPtrToUInt function


## -description


Converts a value of type <b>ULONG_PTR</b> to a value of type <b>UINT</b>.


## -parameters




### -param ulOperand [in]

Type: <b>ULONG_PTR</b>

The value to be converted.


### -param puResult [out]

Type: <b>UINT*</b>

A pointer to the converted value. In the case where the conversion causes a truncation of the original value, the function returns INTSAFE_E_ARITHMETIC_OVERFLOW and this parameter is not valid.


## -returns



Type: <b>HRESULT</b>

If this function succeeds, it returns <b xmlns:loc="http://microsoft.com/wdcml/l10n">S_OK</b>. Otherwise, it returns an <b xmlns:loc="http://microsoft.com/wdcml/l10n">HRESULT</b> error code.




## -remarks



This is one of a set of inline functions designed to provide type conversions and perform validity checks with minimal impact on performance.

<b>SIZETToUInt</b> is an alias for this function.

<b>DWordPtrToUInt</b> is an alias for this function.



