---
UID: NE:ipsectypes.IPSEC_CIPHER_TYPE_
title: IPSEC_CIPHER_TYPE (ipsectypes.h)
description: Indicates the type of encryption algorithm used in an IPsec SA for data privacy.
old-location: fwp\ipsec_cipher_type_enum.htm
tech.root: fwp
ms.assetid: 88bcd239-83a6-4bc6-b9c8-2416c91ee4c4
ms.date: 12/05/2018
ms.keywords: IPSEC_CIPHER_TYPE, IPSEC_CIPHER_TYPE enumeration [Filtering], IPSEC_CIPHER_TYPE_3DES, IPSEC_CIPHER_TYPE_AES_128, IPSEC_CIPHER_TYPE_AES_192, IPSEC_CIPHER_TYPE_AES_256, IPSEC_CIPHER_TYPE_DES, IPSEC_CIPHER_TYPE_MAX, fwp.ipsec_cipher_type_enum, ipsectypes/IPSEC_CIPHER_TYPE, ipsectypes/IPSEC_CIPHER_TYPE_3DES, ipsectypes/IPSEC_CIPHER_TYPE_AES_128, ipsectypes/IPSEC_CIPHER_TYPE_AES_192, ipsectypes/IPSEC_CIPHER_TYPE_AES_256, ipsectypes/IPSEC_CIPHER_TYPE_DES, ipsectypes/IPSEC_CIPHER_TYPE_MAX
f1_keywords:
- ipsectypes/IPSEC_CIPHER_TYPE
dev_langs:
- c++
req.header: ipsectypes.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Ipsectypes.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Ipsectypes.h
api_name:
- IPSEC_CIPHER_TYPE
targetos: Windows
req.typenames: IPSEC_CIPHER_TYPE
req.redist: 
ms.custom: 19H1
---

# IPSEC_CIPHER_TYPE enumeration


## -description


The <b>IPSEC_CIPHER_TYPE</b> enumerated type indicates the type of encryption algorithm used in an IPsec SA for data privacy.


## -enum-fields




### -field IPSEC_CIPHER_TYPE_DES

Specifies DES encryption.


### -field IPSEC_CIPHER_TYPE_3DES

Specifies 3DES encryption.


### -field IPSEC_CIPHER_TYPE_AES_128

Specifies AES-128 encryption.


### -field IPSEC_CIPHER_TYPE_AES_192

Specifies AES-192 encryption.


### -field IPSEC_CIPHER_TYPE_AES_256

Specifies AES-256 encryption.


### -field IPSEC_CIPHER_TYPE_MAX

Maximum value for testing only.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/FWP/fwp-enums">WFP Enumerated Types</a>
 

 

