---
UID: NE:ipsectypes.IPSEC_SA_CONTEXT_EVENT_TYPE0_
title: IPSEC_SA_CONTEXT_EVENT_TYPE0 (ipsectypes.h)
description: Specifies the type of IPsec security association (SA) context change event.
old-location: fwp\ipsec_sa_context_event_type0.htm
tech.root: fwp
ms.assetid: 3e179d08-2962-4196-9c7e-c16c9cddf489
ms.date: 12/05/2018
ms.keywords: IPSEC_SA_CONTEXT_EVENT_ADD, IPSEC_SA_CONTEXT_EVENT_DELETE, IPSEC_SA_CONTEXT_EVENT_MAX, IPSEC_SA_CONTEXT_EVENT_TYPE0, IPSEC_SA_CONTEXT_EVENT_TYPE0 enumeration [Filtering], fwp.ipsec_sa_context_event_type0, ipsectypes/IPSEC_SA_CONTEXT_EVENT_ADD, ipsectypes/IPSEC_SA_CONTEXT_EVENT_DELETE, ipsectypes/IPSEC_SA_CONTEXT_EVENT_MAX, ipsectypes/IPSEC_SA_CONTEXT_EVENT_TYPE0
f1_keywords:
- ipsectypes/IPSEC_SA_CONTEXT_EVENT_TYPE0
dev_langs:
- c++
req.header: ipsectypes.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 8 [desktop apps only]
req.target-min-winversvr: Windows Server 2012 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Ipsectypes.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Ipsectypes.h
api_name:
- IPSEC_SA_CONTEXT_EVENT_TYPE0
targetos: Windows
req.typenames: IPSEC_SA_CONTEXT_EVENT_TYPE0
req.redist: 
ms.custom: 19H1
---

# IPSEC_SA_CONTEXT_EVENT_TYPE0 enumeration


## -description


The <b>IPSEC_SA_CONTEXT_EVENT_TYPE0</b> enumeration specifies the type of IPsec security association (SA) context change event. 


## -enum-fields




### -field IPSEC_SA_CONTEXT_EVENT_ADD

A new IPsec SA context was added.


### -field IPSEC_SA_CONTEXT_EVENT_DELETE

An IPsec SA context was deleted.


### -field IPSEC_SA_CONTEXT_EVENT_MAX

Maximum value for testing purposes.


## -see-also




[IPSEC_SA_CONTEXT_CHANGE0](https://docs.microsoft.com/windows/desktop/api/ipsectypes/ns-ipsectypes-ipsec_sa_context_change0)a>
 

 

