---
UID: NE:ipsectypes.IPSEC_TOKEN_MODE_
title: IPSEC_TOKEN_MODE (ipsectypes.h)
description: Different IPsec modes in which a token can be obtained.
old-location: fwp\ipsec_token_mode.htm
tech.root: fwp
ms.assetid: 5f90e473-39e1-4eed-9ea1-1f20929d5a07
ms.date: 12/05/2018
ms.keywords: IPSEC_TOKEN_MODE, IPSEC_TOKEN_MODE enumeration [Filtering], IPSEC_TOKEN_MODE_EXTENDED, IPSEC_TOKEN_MODE_MAIN, IPSEC_TOKEN_MODE_MAX, fwp.ipsec_token_mode, ipsectypes/IPSEC_TOKEN_MODE, ipsectypes/IPSEC_TOKEN_MODE_EXTENDED, ipsectypes/IPSEC_TOKEN_MODE_MAIN, ipsectypes/IPSEC_TOKEN_MODE_MAX
f1_keywords:
- ipsectypes/IPSEC_TOKEN_MODE
dev_langs:
- c++
req.header: ipsectypes.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Ipsectypes.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Ipsectypes.h
api_name:
- IPSEC_TOKEN_MODE
targetos: Windows
req.typenames: IPSEC_TOKEN_MODE
req.redist: 
ms.custom: 19H1
---

# IPSEC_TOKEN_MODE enumeration


## -description


The <b>IPSEC_TOKEN_MODE</b> enumerated type specifies different IPsec modes in which a token can be obtained.


## -enum-fields




### -field IPSEC_TOKEN_MODE_MAIN

Token was obtained in main mode.


### -field IPSEC_TOKEN_MODE_EXTENDED

Token was obtained in extended mode.


### -field IPSEC_TOKEN_MODE_MAX

Maximum value for testing only. 


## -see-also




[IPSEC_TOKEN0](https://docs.microsoft.com/windows/desktop/api/ipsectypes/ns-ipsectypes-ipsec_token0)a>
 

 

