---
UID: NE:ipsectypes.IPSEC_TRAFFIC_TYPE_
title: IPSEC_TRAFFIC_TYPE (ipsectypes.h)
description: Specifies the type of IPsec traffic being described.
old-location: fwp\ipsec_traffic_type_enum.htm
tech.root: fwp
ms.assetid: e87154ce-7f19-424c-a577-04e2eb81560e
ms.date: 12/05/2018
ms.keywords: IPSEC_TRAFFIC_TYPE, IPSEC_TRAFFIC_TYPE enumeration [Filtering], IPSEC_TRAFFIC_TYPE_MAX, IPSEC_TRAFFIC_TYPE_TRANSPORT, IPSEC_TRAFFIC_TYPE_TUNNEL, fwp.ipsec_traffic_type_enum, ipsectypes/IPSEC_TRAFFIC_TYPE, ipsectypes/IPSEC_TRAFFIC_TYPE_MAX, ipsectypes/IPSEC_TRAFFIC_TYPE_TRANSPORT, ipsectypes/IPSEC_TRAFFIC_TYPE_TUNNEL
f1_keywords:
- ipsectypes/IPSEC_TRAFFIC_TYPE
dev_langs:
- c++
req.header: ipsectypes.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Ipsectypes.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Ipsectypes.h
api_name:
- IPSEC_TRAFFIC_TYPE
targetos: Windows
req.typenames: IPSEC_TRAFFIC_TYPE
req.redist: 
ms.custom: 19H1
---

# IPSEC_TRAFFIC_TYPE enumeration


## -description


The <b>IPSEC_TRAFFIC_TYPE</b> enumerated type specifies the type of IPsec traffic being described.


## -enum-fields




### -field IPSEC_TRAFFIC_TYPE_TRANSPORT

Specifies transport traffic.


### -field IPSEC_TRAFFIC_TYPE_TUNNEL

Specifies tunnel traffic.


### -field IPSEC_TRAFFIC_TYPE_MAX

Maximum value for testing only.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/FWP/fwp-enums">WFP Enumerated Types</a>
 

 

