---
UID: NE:iscsidsc.__unnamed_enum_3
title: TARGETPROTOCOLTYPE (iscsidsc.h)
description: TARGETPROTOCOLTYPE enumeration indicates the type of protocol that the initiator must use to communicate with the target.
old-location: iscsidisc\targetprotocoltype.htm
tech.root: iSCSIDisc
ms.assetid: 1997b1d0-6723-434c-bca7-513e4dc30ee6
ms.date: 12/05/2018
ms.keywords: '*PTARGETPROTOCOLTYPE, ISCSI_TCP_PROTOCOL_TYPE, TARGETPROTOCOLTYPE, TARGETPROTOCOLTYPE enumeration [iSCSI Discovery Library API], iscsidisc.targetprotocoltype, iscsidsc/ISCSI_TCP_PROTOCOL_TYPE, iscsidsc/TARGETPROTOCOLTYPE'
f1_keywords:
- iscsidsc/TARGETPROTOCOLTYPE
dev_langs:
- c++
req.header: iscsidsc.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Iscsidsc.h
api_name:
- TARGETPROTOCOLTYPE
targetos: Windows
req.typenames: TARGETPROTOCOLTYPE, *PTARGETPROTOCOLTYPE
req.redist: 
ms.custom: 19H1
---

# TARGETPROTOCOLTYPE enumeration


## -description


The <b>TARGETPROTOCOLTYPE</b> enumeration indicates the type of protocol that the initiator must use to communicate with the target. 


## -enum-fields




### -field ISCSI_TCP_PROTOCOL_TYPE

The target uses the TCP protocol.


## -see-also




<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/iscsidsc/nf-iscsidsc-getiscsitargetinformationa">GetIScsiTargetInformation</a>
 

 

