---
UID: NS:lmdfs._DFS_INFO_102
title: DFS_INFO_102 (lmdfs.h)
description: Contains a time-out value to associate with a Distributed File System (DFS) root or a link in a named DFS root.
old-location: dfs\dfs_info_102_str.htm
tech.root: Dfs
ms.assetid: ca4da0a2-d5b3-4ad6-bc00-6629b9bf13e7
ms.date: 12/05/2018
ms.keywords: '*LPDFS_INFO_102, *PDFS_INFO_102, DFS_INFO_102, DFS_INFO_102 structure [Distributed File System], LPDFS_INFO_102, LPDFS_INFO_102 structure pointer [Distributed File System], PDFS_INFO_102, PDFS_INFO_102 structure pointer [Distributed File System], _win32_dfs_info_102_str, dfs.dfs_info_102_str, fs.dfs_info_102_str, lmdfs/DFS_INFO_102, lmdfs/LPDFS_INFO_102, lmdfs/PDFS_INFO_102, netmgmt.dfs_info_102_str'
f1_keywords:
- lmdfs/DFS_INFO_102
dev_langs:
- c++
req.header: lmdfs.h
req.include-header: LmDfs.h, Lm.h
req.target-type: Windows
req.target-min-winverclnt: Windows Vista
req.target-min-winversvr: Windows Server 2008
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- LmDfs.h
api_name:
- DFS_INFO_102
targetos: Windows
req.typenames: DFS_INFO_102, *PDFS_INFO_102, *LPDFS_INFO_102
req.redist: 
ms.custom: 19H1
---

# DFS_INFO_102 structure


## -description


Contains a time-out value to associate with a Distributed File System (DFS) root or a link in a named DFS root.


## -struct-fields




### -field Timeout

Specifies the time-out, in seconds, to apply to the specified DFS root or link.


## -see-also




<a href="https://docs.microsoft.com/previous-versions/windows/desktop/dfs/distributed-file-system-dfs-functions">Distributed File System (DFS) Functions</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/lmdfs/nf-lmdfs-netdfssetclientinfo">NetDfsSetClientInfo</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/lmdfs/nf-lmdfs-netdfssetinfo">NetDfsSetInfo</a>



<a href="https://docs.microsoft.com/windows/desktop/NetMgmt/network-management">Network Management Overview</a>



<a href="https://docs.microsoft.com/windows/desktop/NetMgmt/network-management-structures">Network Management Structures</a>
 

 

