---
UID: NF:lpmapi.LPM_GetRsvpObjects
title: LPM_GetRsvpObjects function (lpmapi.h)
description: The LPM_GetRsvpObjects function allows the PCM to query LPMs for policy data.
old-location: qos\lpm_getrsvpobjects.htm
tech.root: QOS
ms.assetid: 1ae417e9-3180-4fd4-90f6-6e91c12d523b
ms.date: 12/05/2018
ms.keywords: FlowDescCount, FlowDescList, LPM_GetRsvpObjects, LPM_GetRsvpObjects callback, LPM_GetRsvpObjects callback function [QOS], RsvpHop, RsvpMsgType, RsvpScope, RsvpSession, RsvpStyle, _gqos_lpm_getrsvpobjects, lpmapi/LPM_GetRsvpObjects, qos.lpm_getrsvpobjects
f1_keywords:
- lpmapi/LPM_GetRsvpObjects
dev_langs:
- c++
req.header: lpmapi.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- UserDefined
api_location:
- Lpmapi.h
api_name:
- LPM_GetRsvpObjects
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# LPM_GetRsvpObjects function


## -description


The 
<i>LPM_GetRsvpObjects</i> function allows the PCM to query LPMs for policy data. The data is forwarded by the PCM to the SBM for inclusion in RSVP refresh messages that require policy data. Results from the 
<i>LPM_GetRsvpObjects</i> function can be returned synchronously or asynchronously. Asynchronous results are returned by calling the 
<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/lpmapi/nc-lpmapi-cbgetrsvpobjects">cbGetRsvpObjects</a> callback function.


## -parameters




### -param PcmReqHandle [in]

Unique handle that distinguishes this request from all other requests. LPMs should use this <i>PcmReqHandle</i> when returning results asynchronously using the 
<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/lpmapi/nc-lpmapi-cbgetrsvpobjects">cbGetRsvpObjects</a> callback function.


### -param MaxPdSize [in]

Maximum allowable size of the returned policy data.


### -param SendingIntfAddr [in]

Pointer to the interface on which the RSVP message will be sent out. The sending interface IP address is supplied as the RSVP HOP object, which equates to PHOP for PATH messages and NHOP for RESV messages. The Logical Interface Handle is set to the SNMP Index. Note that interface index numbers can change with the addition and deletion of interfaces, due to the Plug and Play features of Windows 2000.


### -param pRsvpMsgObjs [in]

RSVP objects generated by the SBM. All RSVP objects are in host order. The objects in the following table are supplied. 



<table>
<tr>
<th>Value</th>
<th>Meaning</th>
</tr>
<tr>
<td width="40%"><a id="RsvpMsgType"></a><a id="rsvpmsgtype"></a><a id="RSVPMSGTYPE"></a><dl>
<dt><b>RsvpMsgType</b></dt>
</dl>
</td>
<td width="60%">
RSVP message type, as defined in the RSVP protocol. This can be used by an LPM to locate the state from which it can generate policy data objects.

</td>
</tr>
<tr>
<td width="40%"><a id="RsvpSession"></a><a id="rsvpsession"></a><a id="RSVPSESSION"></a><dl>
<dt><b>RsvpSession</b></dt>
</dl>
</td>
<td width="60%">
RSVP session for which the SBM requires policy information. This can be used by an LPM to locate the state from which it can generate policy data objects.

</td>
</tr>
<tr>
<td width="40%"><a id="RsvpHop"></a><a id="rsvphop"></a><a id="RSVPHOP"></a><dl>
<dt><b>RsvpHop</b></dt>
</dl>
</td>
<td width="60%">
The HOP to which the RSVP message is being forwarded. Since a PATH message is sent directly to the session address, this HOP pointer is <b>NULL</b> for PATH messages. For all other messages, the address in the HOP object is the node address and the LIH is unused.

</td>
</tr>
<tr>
<td width="40%"><a id="RsvpStyle"></a><a id="rsvpstyle"></a><a id="RSVPSTYLE"></a><dl>
<dt><b>RsvpStyle</b></dt>
</dl>
</td>
<td width="60%">
RSVP reservation style, as defined in the RSVP protocol. If an RESV message is being sent out by the SBM, RsvpStyle specifies the reservation style. If a PATH message is being sent, RsvpStyle is <b>NULL</b>.

</td>
</tr>
<tr>
<td width="40%"><a id="RsvpScope"></a><a id="rsvpscope"></a><a id="RSVPSCOPE"></a><dl>
<dt><b>RsvpScope</b></dt>
</dl>
</td>
<td width="60%">
The RSVP scope of an outgoing RESV message, as long as the SCOPE object is not <b>NULL</b>. Used only for WF-style reservations. For all other RSVP reservation styles, RsvpScope is <b>NULL</b>.

</td>
</tr>
<tr>
<td width="40%"><a id="FlowDescCount"></a><a id="flowdesccount"></a><a id="FLOWDESCCOUNT"></a><dl>
<dt><b>FlowDescCount</b></dt>
</dl>
</td>
<td width="60%">
Number of flow descriptors.

</td>
</tr>
<tr>
<td width="40%"><a id="FlowDescList"></a><a id="flowdesclist"></a><a id="FLOWDESCLIST"></a><dl>
<dt><b>FlowDescList</b></dt>
</dl>
</td>
<td width="60%">
Array of flow descriptor pointers in the outgoing RSVP message. For PATH messages, there will be only one FlowDescriptor containing sender template and sender Tspec.

</td>
</tr>
</table>
 


### -param pRsvpObjectsCount [out]

Pointer to the number of policy objects being returned. When an LPM is immediately returning results, the <i>pRsvpObjectsCount</i> and <i>pppRsvpObjects</i> parameters should be used to return policy data objects. Note that the buffer containing the policy data objects should be allocated using the memory allocation function 
<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/lpmapi/nc-lpmapi-pallocmem">PALLOCMEM</a>, supplied within the 
<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/lpmapi/nf-lpmapi-lpm_initialize">LPM_Initialize</a> function.


### -param pppRsvpObjects [out]

Pointer to an array of policy data object pointers returned in response to the request. Note that the buffer containing the policy data objects, and this array of policy data object pointers, should be allocated using the memory allocation function 
<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/lpmapi/nc-lpmapi-pallocmem">PALLOCMEM</a>, supplied within the 
<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/lpmapi/nf-lpmapi-lpm_initialize">LPM_Initialize</a> function.


### -param Reserved [out]

Reserved for future use.


## -returns



This function returns ULONG.




## -remarks



If an LPM does not have policy data to return from the 
<i>LPM_GetRsvpObjects</i> function call, it should synchronously return LPM_RESULT_READY, set <i>pppRsvpObjects</i> to <b>NULL</b>, and set <i>pRsvpObjectsCount</i> to zero. If a synchronous return is not possible, an LPM should return LPM_RESULT_DEFER, and return the result by calling the 
<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/lpmapi/nc-lpmapi-cbgetrsvpobjects">cbGetRsvpObjects</a> callback function. If the LPM does not have any policy data objects to return, it can set <i>pppRsvpObjects</i> to <b>NULL</b> and <i>pRsvpObjectsCount</i> to zero.

If any LPM returns LPV_DROP_MSG, the SBM will not send out an RSVP refresh message, and will free the policy data objects returned by other LPMs (those that did not return LPM_DROP_MSG, if any). By not sending out RSVP refresh messages, a flow's RSVP state both upstream and downstream will begin to age, and eventually get deleted.

<div class="alert"><b>Note</b>  The SBM will send out the RSVP refresh message even if some or all LPMs fail to return policy data objects in a timely fashion, even though such an outgoing RSVP message may not contain all policy data objects it should.</div>
<div> </div>



## -see-also




<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/lpmapi/nf-lpmapi-lpm_initialize">LPM_Initialize</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/lpmapi/nc-lpmapi-pallocmem">PALLOCMEM</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/lpmapi/nc-lpmapi-cbadmitresult">cbAdmitResult</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/lpmapi/nc-lpmapi-cbgetrsvpobjects">cbGetRsvpObjects</a>
 

 

