---
UID: NF:manipulations.IInertiaProcessor.get_BoundaryBottom
title: IInertiaProcessor::get_BoundaryBottom (manipulations.h)
description: The BoundaryBottom property limits how far towards the bottom of the screen the target object can move.
old-location: wintouch\iinertiaprocessor_bottomboundary.htm
tech.root: wintouch
ms.assetid: 745d51d2-4d9e-4045-929a-2899ff4d2189
ms.date: 12/05/2018
ms.keywords: BoundaryBottom property [Windows Touch], BoundaryBottom property [Windows Touch],IInertiaProcessor interface, IInertiaProcessor interface [Windows Touch],BoundaryBottom property, IInertiaProcessor.BoundaryBottom, IInertiaProcessor.get_BoundaryBottom, IInertiaProcessor::BoundaryBottom, IInertiaProcessor::get_BoundaryBottom, IInertiaProcessor::put_BoundaryBottom, get_BoundaryBottom, manipulations/IInertiaProcessor::BoundaryBottom, manipulations/IInertiaProcessor::get_BoundaryBottom, manipulations/IInertiaProcessor::put_BoundaryBottom, wintouch.iinertiaprocessor_bottomboundary
f1_keywords:
- manipulations/IInertiaProcessor.BoundaryBottom
dev_langs:
- c++
req.header: manipulations.h
req.include-header: Manipulations.h
req.target-type: Windows
req.target-min-winverclnt: Windows 7 [desktop apps only]
req.target-min-winversvr: Windows Server 2008 R2 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- manipulations.h
api_name:
- IInertiaProcessor.BoundaryBottom
- IInertiaProcessor.get_BoundaryBottom
- IInertiaProcessor.put_BoundaryBottom
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IInertiaProcessor::get_BoundaryBottom


## -description


The <b>BoundaryBottom</b> property limits how far towards the bottom of the screen the target object can move.

This property is read/write.


## -parameters


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/manipulations/nf-manipulations-iinertiaprocessor-get_boundaryleft">BoundaryLeft</a>



<a href="https://docs.microsoft.com/windows/desktop/api/manipulations/nf-manipulations-iinertiaprocessor-get_boundaryright">BoundaryRight</a>



<a href="https://docs.microsoft.com/windows/desktop/api/manipulations/nf-manipulations-iinertiaprocessor-get_boundarytop">BoundaryTop</a>



<a href="https://docs.microsoft.com/windows/desktop/wintouch/handling-inertia-in-unmanaged-code">Handling Inertia in Unmanaged Code</a>



<a href="https://docs.microsoft.com/windows/desktop/api/manipulations/nn-manipulations-iinertiaprocessor">IInertiaProcessor</a>



<a href="https://docs.microsoft.com/windows/desktop/wintouch/inertia-mechanics">Inertia Mechanics</a>



<a href="https://docs.microsoft.com/windows/desktop/wintouch/iinertiaprocessor-properties">Properties</a>
 

 

