---
UID: NF:manipulations.IInertiaProcessor.put_BoundaryLeft
title: IInertiaProcessor::put_BoundaryLeft (manipulations.h)
description: The BoundaryLeft property limits how far towards the left of the screen the target object can move.
old-location: wintouch\iinertiaprocessor_leftboundary.htm
tech.root: wintouch
ms.assetid: 476445bb-bf17-4091-a296-73594bd7ed7f
ms.date: 12/05/2018
ms.keywords: BoundaryLeft property [Windows Touch], BoundaryLeft property [Windows Touch],IInertiaProcessor interface, IInertiaProcessor interface [Windows Touch],BoundaryLeft property, IInertiaProcessor.BoundaryLeft, IInertiaProcessor.put_BoundaryLeft, IInertiaProcessor::BoundaryLeft, IInertiaProcessor::get_BoundaryLeft, IInertiaProcessor::put_BoundaryLeft, manipulations/IInertiaProcessor::BoundaryLeft, manipulations/IInertiaProcessor::get_BoundaryLeft, manipulations/IInertiaProcessor::put_BoundaryLeft, put_BoundaryLeft, wintouch.iinertiaprocessor_leftboundary
f1_keywords:
- manipulations/IInertiaProcessor.BoundaryLeft
dev_langs:
- c++
req.header: manipulations.h
req.include-header: Manipulations.h
req.target-type: Windows
req.target-min-winverclnt: Windows 7 [desktop apps only]
req.target-min-winversvr: Windows Server 2008 R2 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- manipulations.h
api_name:
- IInertiaProcessor.BoundaryLeft
- IInertiaProcessor.get_BoundaryLeft
- IInertiaProcessor.put_BoundaryLeft
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IInertiaProcessor::put_BoundaryLeft


## -description


The <b>BoundaryLeft</b> property limits how far towards the left of the screen the target object can move.

This property is read/write.


## -parameters


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/manipulations/nf-manipulations-iinertiaprocessor-get_boundarybottom">BoundaryBottom</a>



<a href="https://docs.microsoft.com/windows/desktop/api/manipulations/nf-manipulations-iinertiaprocessor-get_boundaryright">BoundaryRight</a>



<a href="https://docs.microsoft.com/windows/desktop/api/manipulations/nf-manipulations-iinertiaprocessor-get_boundarytop">BoundaryTop</a>



<a href="https://docs.microsoft.com/windows/desktop/wintouch/handling-inertia-in-unmanaged-code">Handling Inertia in Unmanaged Code</a>



<a href="https://docs.microsoft.com/windows/desktop/api/manipulations/nn-manipulations-iinertiaprocessor">IInertiaProcessor</a>



<a href="https://docs.microsoft.com/windows/desktop/wintouch/inertia-mechanics">Inertia Mechanics</a>



<a href="https://docs.microsoft.com/windows/desktop/wintouch/iinertiaprocessor-properties">Properties</a>
 

 

