---
UID: NS:mfapi._MFPinholeCameraIntrinsics
title: MFPinholeCameraIntrinsics (mfapi.h)
description: Contains zero or 1 pinhole camera intrinsic models that describe how to project a 3D point in physical world onto the 2D image frame of a camera.
old-location: mf\mfpinholecameraintrinsics.htm
tech.root: medfound
ms.assetid: 477F4DF6-CAE5-4BCD-A7D9-B1656DEA11E6
ms.date: 12/05/2018
ms.keywords: MFPinholeCameraIntrinsics, MFPinholeCameraIntrinsics structure [Media Foundation], PMFPinholeCameraIntrinsics, PMFPinholeCameraIntrinsics structure pointer [Media Foundation], mf.mfpinholecameraintrinsics, mfapi/MFPinholeCameraIntrinsics, mfapi/PMFPinholeCameraIntrinsics
f1_keywords:
- mfapi/MFPinholeCameraIntrinsics
dev_langs:
- c++
req.header: mfapi.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 10 [desktop apps only]
req.target-min-winversvr: Windows Server 2016 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- mfapi.h
api_name:
- MFPinholeCameraIntrinsics
targetos: Windows
req.typenames: MFPinholeCameraIntrinsics
req.redist: 
ms.custom: 19H1
---

# MFPinholeCameraIntrinsics structure


## -description


Contains zero or 1 pinhole camera intrinsic models that describe how to project a 3D point in physical world onto the 2D image frame of a camera.


## -struct-fields




### -field IntrinsicModelCount

The number of camera intrinsic models in the <i>IntrinsicModels</i> array.


### -field IntrinsicModels

The array of camera intrinsic models in the intrinsic data.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/medfound/media-foundation-structures">Media Foundation Structures</a>
 

 

