---
UID: NE:mfidl._MF_VIDEO_PROCESSOR_MIRROR
title: MF_VIDEO_PROCESSOR_MIRROR (mfidl.h)
description: Specifies how to flip a video image.
old-location: mf\mf_video_processor_mirror.htm
tech.root: medfound
ms.assetid: AFD29AD7-8DC9-4834-8F8E-D062A3A19BD0
ms.date: 12/05/2018
ms.keywords: MF_VIDEO_PROCESSOR_MIRROR, MF_VIDEO_PROCESSOR_MIRROR enumeration [Media Foundation], MIRROR_HORIZONTAL, MIRROR_NONE, MIRROR_VERTICAL, mf.mf_video_processor_mirror, mfidl/MF_VIDEO_PROCESSOR_MIRROR, mfidl/MIRROR_HORIZONTAL, mfidl/MIRROR_NONE, mfidl/MIRROR_VERTICAL
f1_keywords:
- mfidl/MF_VIDEO_PROCESSOR_MIRROR
dev_langs:
- c++
req.header: mfidl.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 8 [desktop apps only]
req.target-min-winversvr: Windows Server 2012 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- mfidl.h
api_name:
- MF_VIDEO_PROCESSOR_MIRROR
targetos: Windows
req.typenames: MF_VIDEO_PROCESSOR_MIRROR
req.redist: 
ms.custom: 19H1
---

# MF_VIDEO_PROCESSOR_MIRROR enumeration


## -description


Specifies how to flip a video image.


## -enum-fields




### -field MIRROR_NONE

Do not flip the image.


### -field MIRROR_HORIZONTAL

Flip the image horizontally.


### -field MIRROR_VERTICAL

Flip the image vertically.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/mfidl/nf-mfidl-imfvideoprocessorcontrol-setmirror">IMFVideoProcessorControl::SetMirror</a>



<a href="https://docs.microsoft.com/windows/desktop/medfound/media-foundation-enumerations">Media Foundation Enumerations</a>
 

 

