---
UID: NE:mfidl._MFSequencerTopologyFlags
title: MFSequencerTopologyFlags (mfidl.h)
description: Contains flags for adding a topology to the sequencer source, or updating a topology already in the queue.
old-location: mf\mfsequencertopologyflags.htm
tech.root: medfound
ms.assetid: d52bac8c-e490-417c-ac00-e4cf57fd151c
ms.date: 12/05/2018
ms.keywords: MFSequencerTopologyFlags, MFSequencerTopologyFlags enumeration [Media Foundation], SequencerTopologyFlags_Last, d52bac8c-e490-417c-ac00-e4cf57fd151c, mf.mfsequencertopologyflags, mfidl/MFSequencerTopologyFlags, mfidl/SequencerTopologyFlags_Last
f1_keywords:
- mfidl/MFSequencerTopologyFlags
dev_langs:
- c++
req.header: mfidl.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- mfidl.h
api_name:
- MFSequencerTopologyFlags
targetos: Windows
req.typenames: MFSequencerTopologyFlags
req.redist: 
ms.custom: 19H1
---

# MFSequencerTopologyFlags enumeration


## -description



Contains flags for adding a topology to the sequencer source, or updating a topology already in the queue.




## -enum-fields




### -field SequencerTopologyFlags_Last

This topology is the last topology in the sequence.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/mfidl/nf-mfidl-imfsequencersource-appendtopology">IMFSequencerSource::AppendTopology</a>



<a href="https://docs.microsoft.com/windows/desktop/api/mfidl/nf-mfidl-imfsequencersource-updatetopologyflags">IMFSequencerSource::UpdateTopologyFlags</a>



<a href="https://docs.microsoft.com/windows/desktop/medfound/media-foundation-enumerations">Media Foundation Enumerations</a>
 

 

