---
UID: NF:mfidl.MFCreateProtectedEnvironmentAccess
title: MFCreateProtectedEnvironmentAccess function (mfidl.h)
description: Creates an IMFProtectedEnvironmentAccess object that allows content protection systems to perform a handshake with the protected environment.
old-location: mf\mfcreateprotectedenvironmentaccess.htm
tech.root: medfound
ms.assetid: B16BEFFD-26CF-4598-96A4-098C3E3AA51C
ms.date: 12/05/2018
ms.keywords: MFCreateProtectedEnvironmentAccess, MFCreateProtectedEnvironmentAccess function [Media Foundation], mf.mfcreateprotectedenvironmentaccess, mfidl/MFCreateProtectedEnvironmentAccess
f1_keywords:
- mfidl/MFCreateProtectedEnvironmentAccess
dev_langs:
- c++
req.header: mfidl.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 8 [desktop apps \| UWP apps]
req.target-min-winversvr: Windows Server 2012 [desktop apps \| UWP apps]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Mf.lib
req.dll: Mf.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- DllExport
api_location:
- mf.dll
api_name:
- MFCreateProtectedEnvironmentAccess
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# MFCreateProtectedEnvironmentAccess function


## -description


Creates an <a href="https://docs.microsoft.com/windows/desktop/api/mfidl/nn-mfidl-imfprotectedenvironmentaccess">IMFProtectedEnvironmentAccess</a> object that allows content protection systems to perform a handshake with the protected environment.


## -parameters




### -param ppAccess [out]

Receives a pointer to the <a href="https://docs.microsoft.com/windows/desktop/api/mfidl/nn-mfidl-imfprotectedenvironmentaccess">IMFProtectedEnvironmentAccess</a> interface.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/mfidl/nf-mfidl-imfprotectedenvironmentaccess-call">Call</a>



<a href="https://docs.microsoft.com/windows/desktop/api/mfidl/nn-mfidl-imfprotectedenvironmentaccess">IMFProtectedEnvironmentAccess</a>



<a href="https://docs.microsoft.com/windows/desktop/medfound/media-foundation-functions">Media Foundation Functions</a>
 

 

