---
UID: NN:mfidl.IMFMediaStreamSourceSampleRequest
title: IMFMediaStreamSourceSampleRequest (mfidl.h)
description: Represents a request for a sample from a MediaStreamSource.
old-location: mf\imfmediastreamsourcesamplerequest.htm
tech.root: medfound
ms.assetid: 43617cda-84b1-405f-8a20-be793413c186
ms.date: 12/05/2018
ms.keywords: IMFMediaStreamSourceSampleRequest, IMFMediaStreamSourceSampleRequest interface [Media Foundation], IMFMediaStreamSourceSampleRequest interface [Media Foundation],described, mf.imfmediastreamsourcesamplerequest, mfidl/IMFMediaStreamSourceSampleRequest
f1_keywords:
- mfidl/IMFMediaStreamSourceSampleRequest
dev_langs:
- c++
req.header: mfidl.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 8.1 [desktop apps \| UWP apps]
req.target-min-winversvr: Windows Server 2012 R2 [desktop apps \| UWP apps]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Mfidl.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- mfidl.h
api_name:
- IMFMediaStreamSourceSampleRequest
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IMFMediaStreamSourceSampleRequest interface


## -description


Represents a request for a  sample from a MediaStreamSource. 


## -inheritance

The <b xmlns:loc="http://microsoft.com/wdcml/l10n">IMFMediaStreamSourceSampleRequest</b> interface inherits from the <a href="https://docs.microsoft.com/windows/desktop/api/unknwn/nn-unknwn-iunknown">IUnknown</a> interface. <b>IMFMediaStreamSourceSampleRequest</b> also has these types of members:
<ul>
<li><a href="https://docs.microsoft.com/">Methods</a></li>
</ul>

## -members

The <b>IMFMediaStreamSourceSampleRequest</b> interface has these methods.
<table class="members" id="memberListMethods">
<tr>
<th align="left" width="37%">Method</th>
<th align="left" width="63%">Description</th>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/medfound/imfmediastreamsourcesamplerequest-setsample">SetSample</a>
</td>
<td align="left" width="63%">
Sets the sample for the media stream source.

</td>
</tr>
</table> 


## -remarks



<b>MFMediaStreamSourceSampleRequest</b> is implemented by the
     <a href="https://docs.microsoft.com/en-us/uwp/api/windows.media.core.mediastreamsourcesamplerequest">Windows.Media.Core.MediaStreamSourceSampleRequest</a> runtime class.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/medfound/media-foundation-interfaces">Media Foundation Interfaces</a>
 

 

