---
UID: NE:mfmediaengine.MF_MSE_ERROR
title: MF_MSE_ERROR (mfmediaengine.h)
description: Defines the different error states of the Media Source Extension.
old-location: mf\mf_mse_error.htm
tech.root: medfound
ms.assetid: 8FD54833-F60B-49E8-A673-6130F3B06160
ms.date: 12/05/2018
ms.keywords: MF_MSE_ERROR, MF_MSE_ERROR enumeration [Media Foundation], MF_MSE_ERROR_DECODE, MF_MSE_ERROR_NETWORK, MF_MSE_ERROR_NOERROR, MF_MSE_ERROR_UNKNOWN_ERROR, mf.mf_mse_error, mfmediaengine/MF_MSE_ERROR, mfmediaengine/MF_MSE_ERROR_DECODE, mfmediaengine/MF_MSE_ERROR_NETWORK, mfmediaengine/MF_MSE_ERROR_NOERROR, mfmediaengine/MF_MSE_ERROR_UNKNOWN_ERROR
f1_keywords:
- mfmediaengine/MF_MSE_ERROR
dev_langs:
- c++
req.header: mfmediaengine.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 8.1 [desktop apps only]
req.target-min-winversvr: Windows Server 2012 R2 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Mfmediaengine.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- mfmediaengine.h
api_name:
- MF_MSE_ERROR
targetos: Windows
req.typenames: MF_MSE_ERROR
req.redist: 
ms.custom: 19H1
---

# MF_MSE_ERROR enumeration


## -description


Defines the different error states of the Media Source Extension.


## -enum-fields




### -field MF_MSE_ERROR_NOERROR

Specifies no error.


### -field MF_MSE_ERROR_NETWORK

Specifies an error with the network.


### -field MF_MSE_ERROR_DECODE

Specifies an error with decoding.


### -field MF_MSE_ERROR_UNKNOWN_ERROR

Specifies an unknown error.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/medfound/media-foundation-enumerations">Media Foundation Enumerations</a>
 

 

