---
UID: NE:mfmediaengine.MF_TIMED_TEXT_ALIGNMENT
title: MF_TIMED_TEXT_ALIGNMENT (mfmediaengine.h)
description: Specifies how text is aligned in its parent block element.
old-location: mf\mf_timed_text_alignment.htm
tech.root: medfound
ms.assetid: F94DF6A5-1FF7-48C2-834F-50C90B2D9C33
ms.date: 12/05/2018
ms.keywords: MF_TIMED_TEXT_ALIGNMENT, MF_TIMED_TEXT_ALIGNMENT enumeration [Media Foundation], MF_TIMED_TEXT_ALIGNMENT_CENTER, MF_TIMED_TEXT_ALIGNMENT_END, MF_TIMED_TEXT_ALIGNMENT_START, mf.mf_timed_text_alignment, mfmediaengine/MF_TIMED_TEXT_ALIGNMENT, mfmediaengine/MF_TIMED_TEXT_ALIGNMENT_CENTER, mfmediaengine/MF_TIMED_TEXT_ALIGNMENT_END, mfmediaengine/MF_TIMED_TEXT_ALIGNMENT_START
f1_keywords:
- mfmediaengine/MF_TIMED_TEXT_ALIGNMENT
dev_langs:
- c++
req.header: mfmediaengine.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 10 [desktop apps only]
req.target-min-winversvr: Windows Server 2016 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- mfmediaengine.h
api_name:
- MF_TIMED_TEXT_ALIGNMENT
targetos: Windows
req.typenames: MF_TIMED_TEXT_ALIGNMENT
req.redist: 
ms.custom: 19H1
---

# MF_TIMED_TEXT_ALIGNMENT enumeration


## -description


Specifies how text is aligned in its parent block element. 


## -enum-fields




### -field MF_TIMED_TEXT_ALIGNMENT_START

Text is aligned at the start of its parent block element.


### -field MF_TIMED_TEXT_ALIGNMENT_END

Text is aligned at the end of its parent block element.


### -field MF_TIMED_TEXT_ALIGNMENT_CENTER

Text is aligned in the center of its parent block element.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/medfound/media-foundation-enumerations">Media Foundation Enumerations</a>
 

 

