---
UID: NE:mfmediaengine.MF_TIMED_TEXT_DECORATION
title: MF_TIMED_TEXT_DECORATION (mfmediaengine.h)
description: Specifies how text is decorated (underlined and so on).
old-location: mf\mf_timed_text_decoration.htm
tech.root: medfound
ms.assetid: CA2AFC99-F30F-4AFC-928A-45EA7218B851
ms.date: 12/05/2018
ms.keywords: MF_TIMED_TEXT_DECORATION, MF_TIMED_TEXT_DECORATION enumeration [Media Foundation], MF_TIMED_TEXT_DECORATION_LINE_THROUGH, MF_TIMED_TEXT_DECORATION_NONE, MF_TIMED_TEXT_DECORATION_OVERLINE, MF_TIMED_TEXT_DECORATION_UNDERLINE, mf.mf_timed_text_decoration, mfmediaengine/MF_TIMED_TEXT_DECORATION, mfmediaengine/MF_TIMED_TEXT_DECORATION_LINE_THROUGH, mfmediaengine/MF_TIMED_TEXT_DECORATION_NONE, mfmediaengine/MF_TIMED_TEXT_DECORATION_OVERLINE, mfmediaengine/MF_TIMED_TEXT_DECORATION_UNDERLINE
f1_keywords:
- mfmediaengine/MF_TIMED_TEXT_DECORATION
dev_langs:
- c++
req.header: mfmediaengine.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 10 [desktop apps only]
req.target-min-winversvr: Windows Server 2016 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- mfmediaengine.h
api_name:
- MF_TIMED_TEXT_DECORATION
targetos: Windows
req.typenames: MF_TIMED_TEXT_DECORATION
req.redist: 
ms.custom: 19H1
---

# MF_TIMED_TEXT_DECORATION enumeration


## -description


Specifies how text is decorated (underlined and so on). 


## -enum-fields




### -field MF_TIMED_TEXT_DECORATION_NONE

Text isn't decorated.


### -field MF_TIMED_TEXT_DECORATION_UNDERLINE

Text is underlined.


### -field MF_TIMED_TEXT_DECORATION_LINE_THROUGH

Text has a line through it.


### -field MF_TIMED_TEXT_DECORATION_OVERLINE

Text has a line over it.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/medfound/media-foundation-enumerations">Media Foundation Enumerations</a>
 

 

