---
UID: NE:mfmediaengine.MF_TIMED_TEXT_WRITING_MODE
title: MF_TIMED_TEXT_WRITING_MODE (mfmediaengine.h)
description: Specifies the sequence in which text is written on its parent element.
old-location: mf\mf_timed_text_writing_mode.htm
tech.root: medfound
ms.assetid: AE77AC07-EA27-4341-97E4-7D0995AF18E8
ms.date: 12/05/2018
ms.keywords: MF_TIMED_TEXT_WRITING_MODE, MF_TIMED_TEXT_WRITING_MODE enumeration [Media Foundation], MF_TIMED_TEXT_WRITING_MODE_LR, MF_TIMED_TEXT_WRITING_MODE_LRTB, MF_TIMED_TEXT_WRITING_MODE_RL, MF_TIMED_TEXT_WRITING_MODE_RLTB, MF_TIMED_TEXT_WRITING_MODE_TB, MF_TIMED_TEXT_WRITING_MODE_TBLR, MF_TIMED_TEXT_WRITING_MODE_TBRL, mf.mf_timed_text_writing_mode, mfmediaengine/MF_TIMED_TEXT_WRITING_MODE, mfmediaengine/MF_TIMED_TEXT_WRITING_MODE_LR, mfmediaengine/MF_TIMED_TEXT_WRITING_MODE_LRTB, mfmediaengine/MF_TIMED_TEXT_WRITING_MODE_RL, mfmediaengine/MF_TIMED_TEXT_WRITING_MODE_RLTB, mfmediaengine/MF_TIMED_TEXT_WRITING_MODE_TB, mfmediaengine/MF_TIMED_TEXT_WRITING_MODE_TBLR, mfmediaengine/MF_TIMED_TEXT_WRITING_MODE_TBRL
f1_keywords:
- mfmediaengine/MF_TIMED_TEXT_WRITING_MODE
dev_langs:
- c++
req.header: mfmediaengine.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 10 [desktop apps only]
req.target-min-winversvr: Windows Server 2016 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- mfmediaengine.h
api_name:
- MF_TIMED_TEXT_WRITING_MODE
targetos: Windows
req.typenames: MF_TIMED_TEXT_WRITING_MODE
req.redist: 
ms.custom: 19H1
---

# MF_TIMED_TEXT_WRITING_MODE enumeration


## -description


Specifies the sequence in which text is written on its parent element.


## -enum-fields




### -field MF_TIMED_TEXT_WRITING_MODE_LRTB

Text is written from left to right and top to bottom.


### -field MF_TIMED_TEXT_WRITING_MODE_RLTB

Text is written from right to left and top to bottom.


### -field MF_TIMED_TEXT_WRITING_MODE_TBRL

Text is written from top to bottom and right to left.


### -field MF_TIMED_TEXT_WRITING_MODE_TBLR

Text is written from top to bottom and left to right.


### -field MF_TIMED_TEXT_WRITING_MODE_LR

Text is written from left to right.


### -field MF_TIMED_TEXT_WRITING_MODE_RL

Text is written from right to left.


### -field MF_TIMED_TEXT_WRITING_MODE_TB

Text is written from top to bottom.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/medfound/media-foundation-enumerations">Media Foundation Enumerations</a>
 

 

