---
UID: NF:mfmediaengine.IMFTimedTextCue.GetId
title: IMFTimedTextCue::GetId (mfmediaengine.h)
description: Gets the identifier of a timed-text cue.
old-location: mf\imftimedtextcue_getid.htm
tech.root: medfound
ms.assetid: D096B1FA-E92F-4B09-9177-13203FF1704D
ms.date: 12/05/2018
ms.keywords: GetId, GetId method [Media Foundation], GetId method [Media Foundation],IMFTimedTextCue interface, IMFTimedTextCue interface [Media Foundation],GetId method, IMFTimedTextCue.GetId, IMFTimedTextCue::GetId, mf.imftimedtextcue_getid, mfmediaengine/IMFTimedTextCue::GetId
f1_keywords:
- mfmediaengine/IMFTimedTextCue.GetId
dev_langs:
- c++
req.header: mfmediaengine.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Mfmediaengine.lib
req.dll: Mfmediaengine.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- mfmediaengine.dll
api_name:
- IMFTimedTextCue.GetId
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IMFTimedTextCue::GetId


## -description


Gets the identifier of a timed-text cue.


## -parameters






## -returns



Type: <b>DWORD
</b>

The identifier of a timed-text cue.




## -remarks



The identifier is retrieved by this method is dynamically generated by the system and is guaranteed to uniquely identify a cue within a single timed-text track. It is not guaranteed to be unique across tracks. If a cue already has an identifier that is provided in the text-track data format, this ID can be retrieved by calling <a href="https://docs.microsoft.com/windows/desktop/api/mfmediaengine/nf-mfmediaengine-imftimedtextcue-getoriginalid">GetOriginalId</a>.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/mfmediaengine/nf-mfmediaengine-imftimedtextcue-getoriginalid">GetOriginalId</a>



<a href="https://docs.microsoft.com/windows/desktop/api/mfmediaengine/nn-mfmediaengine-imftimedtextcue">IMFTimedTextCue</a>
 

 

