---
UID: NE:mfobjects._MF_Plugin_Type
title: MF_Plugin_Type (mfobjects.h)
description: Specifies the object type for the IMFPluginControl interface.
old-location: mf\mf_plugin_type.htm
tech.root: medfound
ms.assetid: f967cf3f-582c-457a-ba75-980feb2d9bf3
ms.date: 12/05/2018
ms.keywords: MF_Plugin_Type, MF_Plugin_Type enumeration [Media Foundation], MF_Plugin_Type_MFT, MF_Plugin_Type_MFT_MatchOutputType, MF_Plugin_Type_MediaSource, MF_Plugin_Type_Other, mf.mf_plugin_type, mfobjects/, mfobjects/MF_Plugin_Type, mfobjects/MF_Plugin_Type_MFT, mfobjects/MF_Plugin_Type_MFT_MatchOutputType, mfobjects/MF_Plugin_Type_MediaSource, mfobjects/MF_Plugin_Type_Other
f1_keywords:
- mfobjects/MF_Plugin_Type
dev_langs:
- c++
req.header: mfobjects.h
req.include-header: Mfidl.h
req.target-type: Windows
req.target-min-winverclnt: Windows 7 [desktop apps only]
req.target-min-winversvr: Windows Server 2008 R2 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- mfobjects.h
api_name:
- MF_Plugin_Type
targetos: Windows
req.typenames: MF_Plugin_Type
req.redist: 
ms.custom: 19H1
---

# MF_Plugin_Type enumeration


## -description


Specifies the object type for the <a href="https://docs.microsoft.com/windows/desktop/api/mfobjects/nn-mfobjects-imfplugincontrol">IMFPluginControl</a> interface.


## -enum-fields




### -field MF_Plugin_Type_MFT

Media Foundation transform (MFT).


### -field MF_Plugin_Type_MediaSource

Media source.


### -field MF_Plugin_Type_MFT_MatchOutputType

Match output type.


### -field MF_Plugin_Type_Other

Other.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/medfound/media-foundation-enumerations">Media Foundation Enumerations</a>
 

 

