---
UID: NE:mfobjects._MFStandardVideoFormat
title: MFStandardVideoFormat (mfobjects.h)
description: Contains values that specify common video formats.
old-location: mf\mfstandardvideoformat.htm
tech.root: medfound
ms.assetid: 559ea2e9-308b-428a-ae24-bf3fdc27e24e
ms.date: 12/05/2018
ms.keywords: 559ea2e9-308b-428a-ae24-bf3fdc27e24e, MFStandardVideoFormat, MFStandardVideoFormat enumeration [Media Foundation], MFStdVideoFormat_ATSC_HD1080i, MFStdVideoFormat_ATSC_HD720p, MFStdVideoFormat_ATSC_SD480i, MFStdVideoFormat_DVD_NTSC, MFStdVideoFormat_DVD_PAL, MFStdVideoFormat_DV_NTSC, MFStdVideoFormat_DV_PAL, MFStdVideoFormat_NTSC, MFStdVideoFormat_PAL, MFStdVideoFormat_reserved, mf.mfstandardvideoformat, mfobjects/MFStandardVideoFormat, mfobjects/MFStdVideoFormat_ATSC_HD1080i, mfobjects/MFStdVideoFormat_ATSC_HD720p, mfobjects/MFStdVideoFormat_ATSC_SD480i, mfobjects/MFStdVideoFormat_DVD_NTSC, mfobjects/MFStdVideoFormat_DVD_PAL, mfobjects/MFStdVideoFormat_DV_NTSC, mfobjects/MFStdVideoFormat_DV_PAL, mfobjects/MFStdVideoFormat_NTSC, mfobjects/MFStdVideoFormat_PAL, mfobjects/MFStdVideoFormat_reserved
f1_keywords:
- mfobjects/MFStandardVideoFormat
dev_langs:
- c++
req.header: mfobjects.h
req.include-header: Mfidl.h
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- mfobjects.h
api_name:
- MFStandardVideoFormat
targetos: Windows
req.typenames: MFStandardVideoFormat
req.redist: 
ms.custom: 19H1
---

# MFStandardVideoFormat enumeration


## -description



Contains values that specify common video formats.




## -enum-fields




### -field MFStdVideoFormat_reserved

Reserved; do not use.


### -field MFStdVideoFormat_NTSC

NTSC television (720 x 480i).


### -field MFStdVideoFormat_PAL

PAL television (720 x 576i).


### -field MFStdVideoFormat_DVD_NTSC

DVD, NTSC standard (720 x 480).


### -field MFStdVideoFormat_DVD_PAL

DVD, PAL standard (720 x 576).


### -field MFStdVideoFormat_DV_PAL

DV video, PAL standard.


### -field MFStdVideoFormat_DV_NTSC

DV video, NTSC standard.


### -field MFStdVideoFormat_ATSC_SD480i

ATSC digital television, SD (480i).


### -field MFStdVideoFormat_ATSC_HD1080i

ATSC digital television, HD interlaced (1080i)


### -field MFStdVideoFormat_ATSC_HD720p

ATSC digital television, HD progressive (720p)


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/mfapi/nf-mfapi-mfinitvideoformat">MFInitVideoFormat</a>



<a href="https://docs.microsoft.com/windows/desktop/medfound/media-foundation-enumerations">Media Foundation Enumerations</a>
 

 

