---
UID: NS:mfplay.MFP_MF_EVENT
title: MFP_MF_EVENT (mfplay.h)
description: Event structure for the MFP_EVENT_TYPE_MF event.
old-location: mf\mfp_mf_event.htm
tech.root: medfound
ms.assetid: 61dec86d-919c-4b1b-ab2a-527d062ae0f8
ms.date: 12/05/2018
ms.keywords: MFP_MF_EVENT, MFP_MF_EVENT structure [Media Foundation], mf.mfp_mf_event, mfplay/MFP_MF_EVENT
f1_keywords:
- mfplay/MFP_MF_EVENT
dev_langs:
- c++
req.header: mfplay.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 7 [desktop apps only]
req.target-min-winversvr: Windows Server 2008 R2 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- mfplay.h
api_name:
- MFP_MF_EVENT
targetos: Windows
req.typenames: MFP_MF_EVENT
req.redist: 
ms.custom: 19H1
---

# MFP_MF_EVENT structure


## -description



<div class="alert"><b>Important</b>  Deprecated. This API may be removed from future releases of Windows. Applications should use the <a href="https://docs.microsoft.com/windows/desktop/medfound/media-session">Media Session</a> for playback.</div>
<div> </div>


Event structure for the <b>MFP_EVENT_TYPE_MF</b> event. The MFPlay player object uses this event to forward certain events from the Media Foundation pipeline to the application.


## -struct-fields




### -field header


<a href="https://docs.microsoft.com/windows/desktop/api/mfplay/ns-mfplay-mfp_event_header">MFP_EVENT_HEADER</a> structure that contains data common to all <a href="https://docs.microsoft.com/windows/desktop/api/mfplay/nn-mfplay-imfpmediaplayer">IMFPMediaPlayer</a> events.


### -field MFEventType

Media Foundation event type. Currently, the MFPlay player object forwards the following pipeline events to the application:

<table>
<tr>
<th>Event</th>
<th>Description</th>
</tr>
<tr>
<td>
<a href="https://docs.microsoft.com/windows/desktop/medfound/mebufferingstarted">MEBufferingStarted</a>
</td>
<td>The source has started buffering data.</td>
</tr>
<tr>
<td>
<a href="https://docs.microsoft.com/windows/desktop/medfound/mebufferingstopped">MEBufferingStopped</a>
</td>
<td>The source has stopped buffering data.</td>
</tr>
<tr>
<td>
<a href="https://docs.microsoft.com/windows/desktop/medfound/meextendedtype">MEExtendedType</a>
</td>
<td>Custom event type.</td>
</tr>
<tr>
<td>
<a href="https://docs.microsoft.com/windows/desktop/medfound/mereconnectend">MEReconnectEnd</a>
</td>
<td>The source has completed an attempt to reconnect to the server.</td>
</tr>
<tr>
<td>
<a href="https://docs.microsoft.com/windows/desktop/medfound/mereconnectstart">MEReconnectStart</a>
</td>
<td>The source is attempting to reconnect to the server.</td>
</tr>
<tr>
<td>
<a href="https://docs.microsoft.com/windows/desktop/medfound/merendererevent">MERendererEvent</a>
</td>
<td>Event sent by a renderer, such as the <a href="https://docs.microsoft.com/windows/desktop/medfound/enhanced-video-renderer">Enhanced Video Renderer</a> (EVR).</td>
</tr>
<tr>
<td>
<a href="https://docs.microsoft.com/windows/desktop/medfound/mestreamsinkformatchanged">MEStreamSinkFormatChanged</a>
</td>
<td>A stream format has changed.</td>
</tr>
</table>
 


### -field pMFMediaEvent

Pointer to the <a href="https://docs.microsoft.com/windows/desktop/api/mfobjects/nn-mfobjects-imfmediaevent">IMFMediaEvent</a> interface of the Media Foundation event.


### -field pMediaItem

Pointer to the <a href="https://docs.microsoft.com/windows/desktop/api/mfplay/nn-mfplay-imfpmediaitem">IMFPMediaItem</a> interface of the current media item.


## -remarks



To get a pointer to this structure, cast the <i>pEventHeader</i> parameter of the <a href="https://docs.microsoft.com/windows/desktop/api/mfplay/nf-mfplay-imfpmediaplayercallback-onmediaplayerevent">IMFPMediaPlayerCallback::OnMediaPlayerEvent</a> method. You can use the <a href="https://docs.microsoft.com/windows/desktop/api/mfplay/nf-mfplay-mfp_get_mf_event">MFP_GET_MF_EVENT</a> macro for this purpose.

If <b>MFEventType</b> is <a href="https://docs.microsoft.com/windows/desktop/medfound/mestreamsinkformatchanged">MEStreamSinkFormatChanged</a>, the following property may be stored in the event property store, which can be accessed through the <b>header.pPropertyStore</b> member.

<table>
<tr>
<th>Property</th>
<th>Description</th>
</tr>
<tr>
<td>
<a href="https://docs.microsoft.com/previous-versions/windows/desktop/legacy/dd375565(v=vs.85)">MFP_PKEY_StreamIndex</a>
</td>
<td>The index of the stream whose format changed. </td>
</tr>
</table>
 




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/mfplay/nn-mfplay-imfpmediaplayercallback">IMFPMediaPlayerCallback</a>



<a href="https://docs.microsoft.com/windows/desktop/medfound/media-foundation-structures">Media Foundation Structures</a>



<a href="https://docs.microsoft.com/windows/desktop/medfound/using-mfplay-for-audio-video-playback">Using MFPlay for Audio/Video Playback</a>
 

 

