---
UID: NN:mfsharingengine.IPlayToControl
title: IPlayToControl (mfsharingengine.h)
description: Enables the PlayToConnection object to connect to a media element.
old-location: mf\iplaytocontrol.htm
tech.root: medfound
ms.assetid: 53355EEA-559B-4803-89F6-D454E15F9254
ms.date: 12/05/2018
ms.keywords: IPlayToControl, IPlayToControl interface [Media Foundation], IPlayToControl interface [Media Foundation],described, mf.iplaytocontrol, mfsharingengine/IPlayToControl
f1_keywords:
- mfsharingengine/IPlayToControl
dev_langs:
- c++
req.header: mfsharingengine.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 8 [desktop apps only]
req.target-min-winversvr: Windows Server 2012 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- mfsharingengine.h
api_name:
- IPlayToControl
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IPlayToControl interface


## -description


Enables the <b>PlayToConnection</b> object to connect to a media element.


## -inheritance

The <b xmlns:loc="http://microsoft.com/wdcml/l10n">IPlayToControl</b> interface inherits from the <a href="https://docs.microsoft.com/windows/desktop/api/unknwn/nn-unknwn-iunknown">IUnknown</a> interface. <b>IPlayToControl</b> also has these types of members:
<ul>
<li><a href="https://docs.microsoft.com/">Methods</a></li>
</ul>

## -members

The <b>IPlayToControl</b> interface has these methods.
<table class="members" id="memberListMethods">
<tr>
<th align="left" width="37%">Method</th>
<th align="left" width="63%">Description</th>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/mfsharingengine/nf-mfsharingengine-iplaytocontrol-connect">Connect</a>
</td>
<td align="left" width="63%">
Connects the media element to the media sharing engine.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/mfsharingengine/nf-mfsharingengine-iplaytocontrol-disconnect">Disconnect</a>
</td>
<td align="left" width="63%">
Disconnects the media element from the media sharing engine.

</td>
</tr>
</table> 


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/medfound/media-foundation-interfaces">Media Foundation Interfaces</a>
 

 

