---
UID: NE:mftransform._MFT_SET_TYPE_FLAGS
title: _MFT_SET_TYPE_FLAGS (mftransform.h)
description: Defines flags for the setting or testing the media type on a Media Foundation transform (MFT).
old-location: mf\_mft_set_type_flags.htm
tech.root: medfound
ms.assetid: dd7e97fb-80ab-4e6b-ac2a-a257d7e8ec63
ms.date: 12/05/2018
ms.keywords: MFT_SET_TYPE_TEST_ONLY, _MFT_SET_TYPE_FLAGS, _MFT_SET_TYPE_FLAGS enumeration [Media Foundation], dd7e97fb-80ab-4e6b-ac2a-a257d7e8ec63, mf._mft_set_type_flags, mftransform/MFT_SET_TYPE_TEST_ONLY, mftransform/_MFT_SET_TYPE_FLAGS
f1_keywords:
- mftransform/_MFT_SET_TYPE_FLAGS
dev_langs:
- c++
req.header: mftransform.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps \| UWP apps]
req.target-min-winversvr: Windows Server 2008 [desktop apps \| UWP apps]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- mftransform.h
api_name:
- _MFT_SET_TYPE_FLAGS
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# _MFT_SET_TYPE_FLAGS enumeration


## -description



Defines flags for the setting or testing the media type on a Media Foundation transform (MFT).




## -enum-fields




### -field MFT_SET_TYPE_TEST_ONLY

Test the proposed media type, but do not set it.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/mftransform/nf-mftransform-imftransform-setinputtype">IMFTransform::SetInputType</a>



<a href="https://docs.microsoft.com/windows/desktop/api/mftransform/nf-mftransform-imftransform-setoutputtype">IMFTransform::SetOutputType</a>



<a href="https://docs.microsoft.com/windows/desktop/medfound/media-foundation-enumerations">Media Foundation Enumerations</a>



<a href="https://docs.microsoft.com/windows/desktop/medfound/media-foundation-transforms">Media Foundation Transforms</a>
 

 

